/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.nlpcn;

import java.io.IOException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugin.nlpcn.executors.ActionRequestRestExecuterFactory;
import org.elasticsearch.plugin.nlpcn.executors.RestExecutor;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.nlpcn.es4sql.SearchDao;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.QueryAction;

public class RestSqlAction
extends BaseRestHandler {
    public RestSqlAction(Settings settings, RestController restController) {
        super(settings);
        restController.registerHandler(RestRequest.Method.POST, "/_sql/_explain", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/_sql/_explain", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.POST, "/_sql", (RestHandler)this);
        restController.registerHandler(RestRequest.Method.GET, "/_sql", (RestHandler)this);
    }

    public String getName() {
        return "sql_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String sql = request.param("sql");
        if (sql == null) {
            sql = request.content().utf8ToString();
        }
        try {
            SearchDao searchDao = new SearchDao((Client)client);
            QueryAction queryAction = null;
            queryAction = searchDao.explain(sql);
            if (request.path().endsWith("/_explain")) {
                String jsonExplanation = queryAction.explain().explain();
                return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, jsonExplanation));
            }
            Map params = request.params();
            RestExecutor restExecutor = ActionRequestRestExecuterFactory.createExecutor((String)params.get("format"));
            QueryAction finalQueryAction = queryAction;
            HashMap<String, String> additionalParams = new HashMap<String, String>();
            for (String paramName : this.responseParams()) {
                if (!request.hasParam(paramName)) continue;
                additionalParams.put(paramName, request.param(paramName));
            }
            return channel -> restExecutor.execute((Client)client, (Map<String, String>)additionalParams, finalQueryAction, (RestChannel)channel);
        }
        catch (SQLFeatureNotSupportedException | SqlParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Set<String> responseParams() {
        HashSet<String> responseParams = new HashSet<String>(super.responseParams());
        responseParams.addAll(Arrays.asList("sql", "flat", "separator", "_score", "_type", "_id", "newLine", "format"));
        return responseParams;
    }
}

