/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.URIs;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcRecord;

public abstract class WarcTargetRecord
extends WarcRecord {
    WarcTargetRecord(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public String target() {
        return this.headers().sole("WARC-Target-URI").get();
    }

    public URI targetURI() {
        return this.headers().sole("WARC-Target-URI").map(URIs::parseLeniently).get();
    }

    public Optional<WarcDigest> payloadDigest() {
        return this.headers().sole("WARC-Payload-Digest").map(WarcDigest::new);
    }

    public Optional<MediaType> identifiedPayloadType() {
        return this.headers().sole("WARC-Identified-Payload-Type").map(MediaType::parse);
    }

    public Optional<WarcPayload> payload() throws IOException {
        return Optional.of(new WarcPayload(this.body()){

            @Override
            public MediaType type() {
                return WarcTargetRecord.this.contentType();
            }

            @Override
            Optional<MediaType> identifiedType() {
                return Optional.empty();
            }

            @Override
            public Optional<WarcDigest> digest() {
                Optional<WarcDigest> payloadDigest = WarcTargetRecord.this.payloadDigest();
                return payloadDigest.isPresent() ? payloadDigest : WarcTargetRecord.this.blockDigest();
            }
        });
    }

    public Optional<URI> warcinfoID() {
        return this.headers().sole("WARC-Warcinfo-ID").map(WarcRecord::parseRecordID);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.date() + " " + this.target() + ">";
    }

    public static abstract class Builder<R extends WarcTargetRecord, B extends Builder<R, B>>
    extends WarcRecord.AbstractBuilder<R, B> {
        public Builder(String type) {
            super(type);
        }

        public B payloadDigest(WarcDigest payloadDigest) {
            return (B)((Builder)this.addHeader("WARC-Payload-Digest", payloadDigest.prefixedBase32()));
        }

        public B identifiedPayloadType(String identifiedPayloadType) {
            return (B)((Builder)this.setHeader("WARC-Identified-Payload-Type", identifiedPayloadType));
        }

        public B warcinfoId(URI recordId) {
            return (B)((Builder)this.addHeader("WARC-Warcinfo-ID", WarcRecord.formatId(recordId)));
        }

        public B payloadDigest(String algorithm, String value) {
            return this.payloadDigest(new WarcDigest(algorithm, value));
        }
    }
}

