/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;

public abstract class Message {
    private final MessageVersion version;
    private final MessageHeaders headers;
    private final MessageBody body;

    Message(MessageVersion version, MessageHeaders headers, MessageBody body) {
        this.version = version;
        this.headers = headers;
        this.body = body;
    }

    public MessageHeaders headers() {
        return this.headers;
    }

    public MessageBody body() {
        return this.body;
    }

    public MessageVersion version() {
        return this.version;
    }

    public MediaType contentType() {
        return this.headers.sole("Content-Type").map(MediaType::parse).orElse(MediaType.OCTET_STREAM);
    }

    void serializeHeaderTo(Appendable output) throws IOException {
        output.append(this.version().toString());
        output.append("\r\n");
        this.headers.appendTo(output);
        output.append("\r\n");
    }

    Charset headerCharset() {
        return StandardCharsets.UTF_8;
    }

    public byte[] serializeHeader() {
        try {
            StringBuilder sb = new StringBuilder();
            this.serializeHeaderTo(sb);
            return sb.toString().getBytes(this.headerCharset());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static abstract class AbstractBuilder<R extends Message, B extends AbstractBuilder<R, B>> {
        protected Map<String, List<String>> headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        protected MessageVersion version;
        protected ReadableByteChannel bodyChannel;

        public AbstractBuilder(MessageVersion defaultVersion) {
            this.version = defaultVersion;
        }

        public abstract R build();

        public B addHeader(String name, String value) {
            this.headerMap.computeIfAbsent(name, n -> new ArrayList()).add(value);
            return (B)this;
        }

        public B setHeader(String name, String value) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(value);
            this.headerMap.put(name, list);
            return (B)this;
        }

        public B version(MessageVersion version) {
            this.version = version;
            return (B)this;
        }

        public B body(MediaType contentType, byte[] contentBytes) {
            return this.body(contentType, Channels.newChannel(new ByteArrayInputStream(contentBytes)), contentBytes.length);
        }

        public B body(MediaType contentType, ReadableByteChannel channel, long length) {
            this.setHeader("Content-Type", contentType.toString());
            this.setHeader("Content-Length", Long.toString(length));
            this.bodyChannel = channel;
            return (B)this;
        }

        MessageBody makeBody() {
            long contentLength = 0L;
            List<String> values = this.headerMap.get("Content-Length");
            if (values != null && !values.isEmpty()) {
                contentLength = Long.parseLong(values.get(0));
            }
            return LengthedBody.create(this.bodyChannel, ByteBuffer.allocate(0), contentLength);
        }
    }
}

