/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;

class GunzipChannel
implements ReadableByteChannel {
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int CM_DEFLATE = 8;
    private static final short GZIP_MAGIC = -29921;
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer;
    private final Inflater inflater = new Inflater(true);
    private long inputPosition;
    private boolean seenHeader;
    private CRC32 crc;

    public GunzipChannel(ReadableByteChannel channel, ByteBuffer buffer) {
        this.channel = channel;
        this.buffer = buffer;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int read(ByteBuffer dest) throws IOException {
        if (!this.seenHeader) {
            if (!this.readHeader()) {
                return -1;
            }
            this.seenHeader = true;
        }
        if (this.inflater.needsInput()) {
            if (!this.readAtLeast(1)) {
                throw new EOFException("unexpected end of gzip stream");
            }
            this.inflater.setInput(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), this.buffer.remaining());
        }
        try {
            int n = this.inflater.inflate(dest.array(), dest.arrayOffset() + dest.position(), dest.remaining());
            if (this.crc != null) {
                this.crc.update(dest.array(), dest.arrayOffset() + dest.position(), n);
            }
            dest.position(dest.position() + n);
            int newBufferPosition = this.buffer.limit() - this.inflater.getRemaining();
            this.inputPosition += (long)(newBufferPosition - this.buffer.position());
            this.buffer.position(newBufferPosition);
            if (this.inflater.finished()) {
                this.readTrailer();
                this.inflater.reset();
                if (this.crc != null) {
                    this.crc.reset();
                }
                this.seenHeader = false;
            }
            return n;
        }
        catch (DataFormatException e) {
            throw new ZipException(e.getMessage());
        }
    }

    private void readTrailer() throws IOException {
        if (!this.readAtLeast(8)) {
            throw new EOFException("reading gzip trailer");
        }
        long expectedCrc = (long)this.buffer.getInt() & 0xFFFFFFFFL;
        int isize = this.buffer.getInt();
        this.inputPosition += 8L;
        if (((long)isize & 0xFFFFFFFFFL) != (this.inflater.getBytesWritten() & 0xFFFFFFFFFL)) {
            throw new ZipException("gzip uncompressed size mismatch");
        }
        if (this.crc != null && expectedCrc != this.crc.getValue()) {
            throw new ZipException("bad gzip crc32: expected " + Long.toHexString(expectedCrc) + " actual " + Long.toHexString(this.crc.getValue()));
        }
    }

    private boolean readHeader() throws IOException {
        if (!this.readAtLeast(10)) {
            if (this.buffer.hasRemaining()) {
                throw new EOFException("partial gzip header");
            }
            return false;
        }
        short magic = this.buffer.getShort();
        if (magic != -29921) {
            throw new ZipException("not in gzip format (magic=" + Integer.toHexString(magic) + ")");
        }
        byte cm = this.buffer.get();
        if (cm != 8) {
            throw new ZipException("unsupported compression method: " + cm);
        }
        byte flg = this.buffer.get();
        int mtime = this.buffer.getInt();
        byte xfl = this.buffer.get();
        byte os = this.buffer.get();
        this.inputPosition += 10L;
        if ((flg & 4) == 4) {
            if (!this.readAtLeast(2)) {
                throw new EOFException("reading gzip extra");
            }
            int xlen = this.buffer.getShort();
            ByteBuffer extra = ByteBuffer.allocate(xlen);
            while (extra.hasRemaining()) {
                for (int i = 0; i < xlen; ++i) {
                    if (!this.readAtLeast(1)) {
                        throw new EOFException("reading gzip extra");
                    }
                    extra.put(this.buffer.get());
                }
                this.inputPosition += (long)xlen;
            }
        }
        if ((flg & 8) == 8) {
            do {
                if (!this.readAtLeast(1)) {
                    throw new EOFException("reading gzip name");
                }
                ++this.inputPosition;
            } while (this.buffer.get() != 0);
        }
        if ((flg & 0x10) == 16) {
            do {
                if (!this.readAtLeast(1)) {
                    throw new EOFException("reading gzip comment");
                }
                ++this.inputPosition;
            } while (this.buffer.get() != 0);
        }
        if ((flg & 2) == 2) {
            if (!this.readAtLeast(2)) {
                throw new EOFException("reading gzip header crc");
            }
            short crc16 = this.buffer.getShort();
            this.inputPosition += 2L;
        }
        return true;
    }

    private boolean readAtLeast(int n) throws IOException {
        while (this.buffer.remaining() < n) {
            this.buffer.compact();
            int actual = this.channel.read(this.buffer);
            this.buffer.flip();
            if (actual >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public long inputPosition() {
        return this.inputPosition;
    }
}

