/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.net.URI;
import java.time.Instant;
import java.util.Optional;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcRecord;

public class WarcRevisit
extends WarcCaptureRecord {
    public static final URI IDENTICAL_PAYLOAD_DIGEST_1_0 = URI.create("http://netpreserve.org/warc/1.0/revisit/identical-payload-digest");
    public static final URI IDENTICAL_PAYLOAD_DIGEST_1_1 = URI.create("http://netpreserve.org/warc/1.1/revisit/identical-payload-digest");
    public static final URI SERVER_NOT_MODIFIED_1_0 = URI.create("http://netpreserve.org/warc/1.0/revisit/server-not-modified");
    public static final URI SERVER_NOT_MODIFIED_1_1 = URI.create("http://netpreserve.org/warc/1.1/revisit/server-not-modified");

    WarcRevisit(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public Optional<URI> refersToTargetURI() {
        return this.headers().sole("WARC-Refers-To-Target-URI").map(URI::create);
    }

    public Optional<Instant> refersToDate() {
        return this.headers().sole("WARC-Refers-To-Date").map(Instant::parse);
    }

    public URI profile() {
        return this.headers().sole("WARC-Profile").map(URI::create).get();
    }

    public Optional<URI> refersTo() {
        return this.headers().sole("WARC-Refers-To").map(WarcRecord::parseRecordID);
    }

    public static class Builder
    extends WarcCaptureRecord.AbstractBuilder<WarcRevisit, Builder> {
        public Builder(URI profile) {
            super("revisit");
            this.setHeader("WARC-Profile", profile.toString());
        }

        @Override
        public WarcRevisit build() {
            return this.build(WarcRevisit::new);
        }

        public Builder refersTo(URI recordId) {
            return (Builder)this.setHeader("WARC-Refers-To", WarcRecord.formatId(recordId));
        }

        public Builder refersTo(URI recordId, URI targetURI, Instant date) {
            this.setHeader("WARC-Refers-To-Target-URI", targetURI.toString());
            this.setHeader("WARC-Refers-To-Date", date.toString());
            return this.refersTo(recordId);
        }
    }
}

