/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.netpreserve.jwarc.HttpMessage;
import org.netpreserve.jwarc.HttpParser;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;

public class HttpRequest
extends HttpMessage {
    private final String method;
    private final String target;

    HttpRequest(String method, String target, MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
        this.method = method;
        this.target = target;
    }

    public String target() {
        return this.target;
    }

    public String method() {
        return this.method;
    }

    @Override
    void serializeHeaderTo(Appendable output) throws IOException {
        output.append(this.method);
        output.append(' ');
        output.append(this.target);
        output.append(' ');
        output.append(this.version().toString());
        output.append("\r\n");
        this.headers().appendTo(output);
        output.append("\r\n");
    }

    public static HttpRequest parse(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        buffer.flip();
        return HttpRequest.parse(channel, buffer);
    }

    public static HttpRequest parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        return HttpRequest.parse(channel, buffer, null);
    }

    static HttpRequest parse(ReadableByteChannel channel, ByteBuffer buffer, WritableByteChannel copyTo) throws IOException {
        HttpParser parser = new HttpParser();
        parser.requestOnly();
        parser.parse(channel, buffer, copyTo);
        if (copyTo != null) {
            copyTo.write(buffer.duplicate());
        }
        MessageHeaders headers = parser.headers();
        long contentLength = headers.sole("Content-Length").map(Long::parseLong).orElse(-1L);
        LengthedBody body = LengthedBody.create(channel, buffer, contentLength);
        return new HttpRequest(parser.method(), parser.target(), parser.version(), headers, body);
    }

    public static class Builder
    extends HttpMessage.AbstractBuilder<HttpRequest, Builder> {
        private final String method;
        private final String target;

        public Builder(String method, String target) {
            this.method = method;
            this.target = target;
        }

        @Override
        public HttpRequest build() {
            return new HttpRequest(this.method, this.target, this.version, new MessageHeaders(this.headerMap), this.makeBody());
        }
    }
}

