/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcFilter;
import org.netpreserve.jwarc.WarcFilterException;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRecorder;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcServer;
import org.netpreserve.jwarc.WarcWriter;

public class WarcTool {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            WarcTool.usage();
            return;
        }
        Command cmd = Command.valueOf(args[0]);
        cmd.exec(Arrays.copyOfRange(args, 1, args.length));
    }

    private static void usage() {
        System.err.println("usage: jwarc command [args]\n\nCommands:\n");
        for (Command cmd : Command.values()) {
            System.err.format("    %-10s %s\n", cmd.name(), cmd.help);
        }
    }

    private static void runBrowser(InetSocketAddress proxy, String ... args) throws IOException, InterruptedException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList(System.getenv().getOrDefault("BROWSER", "google-chrome"), "--headless", "--disable-gpu", "--disable-breakpad", "--ignore-certificate-errors", "--proxy-server=" + proxy.getHostString() + ":" + proxy.getPort(), "--hide-scrollbars"));
        cmd.addAll(Arrays.asList(args));
        System.err.println(String.join((CharSequence)" ", cmd));
        Process p = new ProcessBuilder(cmd).inheritIO().redirectOutput(new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null")).start();
        p.waitFor();
    }

    private static enum Command {
        cdx("List records in CDX format"){

            @Override
            void exec(String[] args) throws Exception {
                DateTimeFormatter arcDate = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
                for (String arg : args) {
                    try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                        WarcRecord record = reader.next().orElse(null);
                        while (record != null) {
                            if ((record instanceof WarcResponse || record instanceof WarcResource) && ((WarcCaptureRecord)record).payload().isPresent()) {
                                MediaType type;
                                WarcPayload payload = ((WarcCaptureRecord)record).payload().get();
                                try {
                                    type = payload.type().base();
                                }
                                catch (IllegalArgumentException e) {
                                    type = MediaType.OCTET_STREAM;
                                }
                                URI uri = ((WarcCaptureRecord)record).targetURI();
                                String date = arcDate.format(record.date());
                                int status = record instanceof WarcResponse ? ((WarcResponse)record).http().status() : 200;
                                String digest = payload.digest().map(WarcDigest::toBase32).orElse("-");
                                long position = reader.position();
                                record = reader.next().orElse(null);
                                long length = reader.position() - position;
                                System.out.printf("%s %s %s %s %d %s - - %d %d %s%n", uri, date, uri, type, status, digest, length, position, arg);
                                continue;
                            }
                            record = reader.next().orElse(null);
                        }
                    }
                }
            }
        }
        ,
        fetch("Download a URL recording the request and response"){

            @Override
            void exec(String[] args) throws IOException, URISyntaxException {
                try (WarcWriter writer = new WarcWriter(System.out);){
                    for (String arg : args) {
                        writer.fetch(new URI(arg));
                    }
                }
            }
        }
        ,
        filter("Copy records that match a given filter expression"){

            @Override
            void exec(String[] args) throws Exception {
                try {
                    String[] files;
                    if (args.length == 0) {
                        System.err.println("Usage: jwarc filter <expression> [warc-file]...");
                        System.err.println("  e.g. jwarc filter 'warc-type == \"response\" && http:content-type =~ \"image/.*\" && :status == 200' example.warc");
                        System.exit(1);
                        return;
                    }
                    if (args.length > 1) {
                        files = Arrays.copyOfRange(args, 1, args.length);
                    } else {
                        if (System.console() != null) {
                            System.err.println("Warning: No input files specified, reading from STDIN");
                        }
                        files = new String[]{"-"};
                    }
                    WarcFilter filter = WarcFilter.compile(args[0]);
                    try (WarcWriter writer = new WarcWriter(System.out);){
                        for (String file : files) {
                            try (WarcReader reader = file.equals("-") ? new WarcReader(System.in) : new WarcReader(Paths.get(file, new String[0]));){
                                this.filterRecords(filter, writer, reader);
                            }
                        }
                    }
                }
                catch (WarcFilterException e) {
                    System.err.println(e.prettyPrint());
                    System.exit(2);
                }
            }

            private void filterRecords(WarcFilter filter, WarcWriter writer, WarcReader reader) throws IOException {
                for (WarcRecord record : reader) {
                    if (!filter.test(record)) continue;
                    writer.write(record);
                }
            }
        }
        ,
        ls("List records in WARC file(s)"){

            @Override
            void exec(String[] args) throws IOException {
                for (String arg : args) {
                    try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                        for (WarcRecord record : reader) {
                            System.out.println(record);
                        }
                    }
                }
            }
        }
        ,
        record("Fetch a page and subresources using headless Chrome"){

            @Override
            void exec(String[] args) throws Exception {
                try (ServerSocket socket = new ServerSocket(0, -1, InetAddress.getLoopbackAddress());){
                    WarcRecorder recorder = new WarcRecorder(socket, new WarcWriter(System.out));
                    new Thread(() -> {
                        try {
                            recorder.listen();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }).start();
                    InetSocketAddress address = (InetSocketAddress)socket.getLocalSocketAddress();
                    System.err.println("WarcRecorder listening on " + address);
                    for (String arg : args) {
                        WarcTool.runBrowser(address, new String[]{arg});
                    }
                }
                System.exit(0);
            }
        }
        ,
        recorder("Run a recording proxy"){

            @Override
            void exec(String[] args) throws Exception {
                int port = Integer.parseInt(System.getenv().getOrDefault("PORT", "8080"));
                new WarcRecorder(new ServerSocket(port), new WarcWriter(System.out)).listen();
            }
        }
        ,
        screenshot("Take a screenshot of each page in the given WARCs"){

            @Override
            void exec(String[] args) throws Exception {
                List<Path> warcs = Stream.of(args).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
                try (WarcWriter warcWriter = new WarcWriter(System.out);
                     ServerSocket serverSocket = new ServerSocket(0, -1, InetAddress.getLoopbackAddress());){
                    WarcServer warcServer = new WarcServer(serverSocket, warcs);
                    InetSocketAddress address = (InetSocketAddress)serverSocket.getLocalSocketAddress();
                    System.err.println("Replay proxy listening on " + address);
                    new Thread(() -> {
                        try {
                            warcServer.listen();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }).start();
                    for (String arg : args) {
                        try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                            for (WarcRecord record : reader) {
                                if (!this.isNormalPage(record)) continue;
                                WarcCaptureRecord capture = (WarcCaptureRecord)record;
                                this.screenshot(address, capture, warcWriter);
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void screenshot(InetSocketAddress proxy, WarcCaptureRecord capture, WarcWriter warcWriter) throws IOException, InterruptedException {
                Path screenshot = Files.createTempFile("jwarc-screenshot", ".png", new FileAttribute[0]);
                try {
                    String url = capture.targetURI().toString();
                    WarcTool.runBrowser(proxy, new String[]{"--screenshot=" + screenshot, url});
                    try (FileChannel channel = FileChannel.open(screenshot, new OpenOption[0]);){
                        long size = channel.size();
                        if (size == 0L) {
                            return;
                        }
                        warcWriter.write(((WarcResource.Builder)((WarcResource.Builder)new WarcResource.Builder(URI.create("screenshot:" + url)).date(capture.date())).body(MediaType.parse("image/png"), channel, size)).build());
                    }
                }
                finally {
                    Files.deleteIfExists(screenshot);
                }
            }

            private boolean isNormalPage(WarcRecord record) throws IOException {
                if (!(record instanceof WarcResponse) && !(record instanceof WarcResource)) {
                    return false;
                }
                WarcCaptureRecord capture = (WarcCaptureRecord)record;
                String scheme = capture.targetURI().getScheme();
                if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                    return false;
                }
                try {
                    if (!capture.payload().isPresent() || !capture.payload().get().type().base().equals(MediaType.HTML)) {
                        return false;
                    }
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                return !(capture instanceof WarcResponse) || ((WarcResponse)capture).http().status() == 200;
            }
        }
        ,
        serve("Serve WARC files with a basic replay server/proxy"){

            @Override
            void exec(String[] args) throws Exception {
                if (args.length == 0) {
                    System.err.println("Usage: WarcTool serve <warc-files>");
                    System.err.println("Obeys environment variable PORT.");
                    System.exit(1);
                }
                List<Path> warcs = Stream.of(args).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
                int port = Integer.parseInt(System.getenv().getOrDefault("PORT", "8080"));
                WarcServer server = new WarcServer(new ServerSocket(port), warcs);
                System.err.println("Listening on port " + port);
                server.listen();
            }
        }
        ,
        version("Print version information"){

            @Override
            void exec(String[] args) throws Exception {
                Properties properties = new Properties();
                URL resource = ((Object)((Object)this)).getClass().getResource("/META-INF/maven/org.netpreserve/jwarc/pom.properties");
                if (resource != null) {
                    try (InputStream stream = resource.openStream();){
                        properties.load(stream);
                    }
                }
                String version = properties.getProperty("version", "unknown version");
                System.out.println("jwarc " + version);
                System.out.println(System.getProperty("java.vm.name") + " " + System.getProperty("java.version"));
                System.out.println(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
            }
        };

        private final String help;

        private Command(String help) {
            this.help = help;
        }

        abstract void exec(String[] var1) throws Exception;
    }
}

