/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Optional;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;

public class WarcRequest
extends WarcCaptureRecord {
    private HttpRequest http;

    WarcRequest(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public HttpRequest http() throws IOException {
        if (this.http == null) {
            ByteBuffer buffer = ByteBuffer.allocate(8192);
            buffer.flip();
            MessageBody body = this.body();
            if (body.position() != 0L) {
                throw new IllegalStateException("http() cannot be called after reading from body");
            }
            if (body instanceof LengthedBody) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                LengthedBody lengthed = (LengthedBody)body;
                this.http = HttpRequest.parse(lengthed.discardPushbackOnRead(), buffer, Channels.newChannel(baos));
                lengthed.pushback(baos.toByteArray());
            } else {
                this.http = HttpRequest.parse(body, buffer);
            }
        }
        return this.http;
    }

    @Override
    public MediaType payloadType() throws IOException {
        return this.http().contentType();
    }

    @Override
    public Optional<WarcPayload> payload() throws IOException {
        if (this.contentType().base().equals(MediaType.HTTP)) {
            return Optional.of(new WarcPayload(this.http().body()){

                @Override
                MediaType type() {
                    return WarcRequest.this.http.contentType();
                }

                @Override
                Optional<MediaType> identifiedType() {
                    return WarcRequest.this.identifiedPayloadType();
                }

                @Override
                Optional<WarcDigest> digest() {
                    return WarcRequest.this.payloadDigest();
                }
            });
        }
        return Optional.empty();
    }

    public static class Builder
    extends WarcCaptureRecord.AbstractBuilder<WarcRequest, Builder> {
        public Builder(URI targetURI) {
            super("request");
            this.setHeader("WARC-Target-URI", targetURI.toString());
        }

        @Override
        public WarcRequest build() {
            return this.build(WarcRequest::new);
        }

        public Builder body(HttpRequest httpRequest) throws IOException {
            return (Builder)this.body(MediaType.HTTP_REQUEST, httpRequest);
        }
    }
}

