/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.netpreserve.jwarc.CertificateAuthority;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.IOUtils;

class HttpServer {
    private final ServerSocket serverSocket;
    private final CertificateAuthority ca;
    private final Handler handler;

    HttpServer(ServerSocket serverSocket, Handler handler) {
        this.serverSocket = serverSocket;
        this.handler = handler;
        try {
            this.ca = new CertificateAuthority(new X500Principal("cn=Dummy CA"));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    void listen() throws IOException {
        ExecutorService threadPool = Executors.newCachedThreadPool(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("HttpServer worker");
            return thread;
        });
        try {
            while (!this.serverSocket.isClosed()) {
                Socket socket = this.serverSocket.accept();
                threadPool.execute(() -> this.interact(socket, ""));
            }
        }
        finally {
            threadPool.shutdown();
        }
    }

    /*
     * Exception decompiling
     */
    private void interact(Socket socket, String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void upgradeToTls(Socket socket, String target) throws Exception {
        HttpServer.send(socket, new HttpResponse.Builder(200, "OK").build());
        final String host = target.replaceFirst(":[0-9]+$", "");
        final X509Certificate cert = this.ca.issue(new X500Principal("cn=" + host));
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[]{new X509KeyManager(){

            @Override
            public X509Certificate[] getCertificateChain(String alias) {
                return new X509Certificate[]{cert, ((HttpServer)HttpServer.this).ca.caCert};
            }

            @Override
            public PrivateKey getPrivateKey(String s) {
                return ((HttpServer)HttpServer.this).ca.subKeyPair.getPrivate();
            }

            @Override
            public String[] getClientAliases(String s, Principal[] principals) {
                throw new IllegalStateException();
            }

            @Override
            public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                throw new IllegalStateException();
            }

            @Override
            public String[] getServerAliases(String s, Principal[] principals) {
                return new String[]{host};
            }

            @Override
            public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                return host;
            }
        }}, null, null);
        SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(socket, null, true);
        sslSocket.setUseClientMode(false);
        sslSocket.startHandshake();
        this.interact(sslSocket, "https://" + target.replaceFirst(":443$", ""));
    }

    static void send(Socket socket, HttpResponse response) throws IOException {
        try {
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(response.serializeHeader());
            IOUtils.copy(response.body().stream(), outputStream);
        }
        catch (SocketException | SSLProtocolException e) {
            socket.close();
        }
    }

    static interface Handler {
        public void handle(Socket var1, String var2, HttpRequest var3) throws Exception;
    }
}

