/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.ParsingException;

public class HttpParser {
    private int cs;
    private long position;
    private boolean finished;
    private byte[] buf = new byte[256];
    private int bufPos = 0;
    private int endOfText;
    private int major;
    private int minor;
    private int status;
    private String reason;
    private String method;
    private String target;
    private String name;
    private Map<String, List<String>> headerMap;
    private static final byte[] _http_actions = HttpParser.init__http_actions_0();
    private static final short[] _http_key_offsets = HttpParser.init__http_key_offsets_0();
    private static final char[] _http_trans_keys = HttpParser.init__http_trans_keys_0();
    private static final byte[] _http_single_lengths = HttpParser.init__http_single_lengths_0();
    private static final byte[] _http_range_lengths = HttpParser.init__http_range_lengths_0();
    private static final short[] _http_index_offsets = HttpParser.init__http_index_offsets_0();
    private static final byte[] _http_indicies = HttpParser.init__http_indicies_0();
    private static final byte[] _http_trans_targs = HttpParser.init__http_trans_targs_0();
    private static final byte[] _http_trans_actions = HttpParser.init__http_trans_actions_0();
    static final int http_start = 1;
    static final int http_first_final = 48;
    static final int http_error = 0;
    static final int http_en_http_request = 25;
    static final int http_en_http_response = 1;

    public HttpParser() {
        this.reset();
    }

    public void reset() {
        this.cs = 1;
        this.bufPos = 0;
        if (this.buf.length > 8192) {
            this.buf = new byte[256];
        }
        this.major = 0;
        this.minor = 0;
        this.status = 0;
        this.reason = null;
        this.method = null;
        this.target = null;
        this.name = null;
        this.headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.endOfText = 0;
        this.position = 0L;
        this.finished = false;
    }

    public MessageHeaders headers() {
        return new MessageHeaders(this.headerMap);
    }

    public MessageVersion version() {
        return new MessageVersion("HTTP", this.major, this.minor);
    }

    public int status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public String target() {
        return this.target;
    }

    public String method() {
        return this.method;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isError() {
        return this.cs == 0;
    }

    public void requestOnly() {
        this.cs = 25;
    }

    public void responseOnly() {
        this.cs = 1;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(ByteBuffer data) {
        p = data.position();
        pe = data.limit();
        _trans = 0;
        _goto_targ = 0;
        block19: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block19;
                    }
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block19;
                    }
                }
                case 1: {
                    _keys = HttpParser._http_key_offsets[this.cs];
                    _trans = HttpParser._http_index_offsets[this.cs];
                    _klen = HttpParser._http_single_lengths[this.cs];
                    if (_klen <= 0) ** GOTO lbl33
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (data.get(p) < HttpParser._http_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (data.get(p) > HttpParser._http_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl47
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl33:
                    // 2 sources

                    if ((_klen = HttpParser._http_range_lengths[this.cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (data.get(p) < HttpParser._http_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (data.get(p) > HttpParser._http_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl47
                        }
                        _trans += _klen;
                    }
lbl47:
                    // 5 sources

                    _trans = HttpParser._http_indicies[_trans];
                    this.cs = HttpParser._http_trans_targs[_trans];
                    if (HttpParser._http_trans_actions[_trans] != 0) {
                        _acts = HttpParser._http_trans_actions[_trans];
                        _nacts = HttpParser._http_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (HttpParser._http_actions[_acts++]) {
                                case 0: {
                                    this.push(data.get(p));
                                    break;
                                }
                                case 1: {
                                    this.major = this.major * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 2: {
                                    this.minor = this.minor * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 3: {
                                    this.status = this.status * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 4: {
                                    this.endOfText = this.bufPos;
                                    break;
                                }
                                case 5: {
                                    this.method = new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 6: {
                                    this.reason = new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 7: {
                                    this.target = new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 8: {
                                    this.finished = true;
                                    break;
                                }
                                case 9: {
                                    if (this.bufPos <= 0) break;
                                    this.bufPos = this.endOfText;
                                    this.push((byte)32);
                                    break;
                                }
                                case 10: {
                                    this.name = new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 11: {
                                    value = new String(this.buf, 0, this.endOfText, StandardCharsets.ISO_8859_1);
                                    this.headerMap.computeIfAbsent(this.name, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parse$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(value);
                                    this.bufPos = 0;
                                    this.endOfText = 0;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block19;
                    }
                    if (++p == pe) break block19;
                    _goto_targ = 1;
                    continue block19;
                }
            }
            break;
        }
        this.position += (long)(p - data.position());
        data.position(p);
    }

    public void parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        this.parse(channel, buffer, null);
    }

    void parse(ReadableByteChannel channel, ByteBuffer buffer, WritableByteChannel copyTo) throws IOException {
        while (true) {
            ByteBuffer copy = buffer.duplicate();
            this.parse(buffer);
            if (copyTo != null) {
                copy.limit(buffer.position());
                copyTo.write(copy);
            }
            if (this.isFinished()) break;
            if (this.isError()) {
                throw new ParsingException("invalid HTTP message at byte position " + this.position);
            }
            buffer.compact();
            int n = channel.read(buffer);
            if (n < 0) {
                throw new EOFException("state=" + this.cs);
            }
            buffer.flip();
        }
    }

    private void push(byte b) {
        if (this.bufPos >= this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
        }
        this.buf[this.bufPos++] = b;
    }

    private static byte[] init__http_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 2, 4, 0, 2, 9, 0, 2, 11, 0};
    }

    private static short[] init__http_key_offsets_0() {
        return new short[]{0, 0, 1, 2, 3, 4, 5, 7, 8, 10, 11, 13, 15, 17, 18, 24, 25, 41, 42, 58, 65, 66, 84, 91, 98, 105, 120, 136, 148, 161, 162, 163, 164, 165, 166, 168, 169, 171, 172, 173, 189, 190, 206, 213, 214, 232, 239, 246, 253, 253};
    }

    private static char[] init__http_trans_keys_0() {
        return new char[]{'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', ' ', '0', '9', '0', '9', '0', '9', ' ', '\t', '\r', ' ', '~', '\u0080', '\u00ff', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '=', '_', '~', '$', ';', '?', 'Z', 'a', 'z', '\u0080', '\u00ff', ' ', '!', '=', '_', '~', '$', ';', '?', 'Z', 'a', 'z', '\u0080', '\u00ff', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', '\r', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\u0000'};
    }

    private static byte[] init__http_single_lengths_0() {
        return new byte[]{0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 2, 1, 4, 1, 4, 3, 1, 6, 3, 3, 3, 3, 4, 4, 5, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 4, 1, 4, 3, 1, 6, 3, 3, 3, 0, 0};
    }

    private static byte[] init__http_range_lengths_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 2, 0, 6, 0, 6, 2, 0, 6, 2, 2, 2, 6, 6, 4, 4, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 6, 0, 6, 2, 0, 6, 2, 2, 2, 0, 0};
    }

    private static short[] init__http_index_offsets_0() {
        return new short[]{0, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 31, 33, 44, 46, 57, 63, 65, 78, 84, 90, 96, 106, 117, 126, 136, 138, 140, 142, 144, 146, 148, 150, 152, 154, 156, 167, 169, 180, 186, 188, 201, 207, 213, 219, 220};
    }

    private static byte[] init__http_indicies_0() {
        return new byte[]{0, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 15, 14, 14, 1, 16, 1, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 1, 19, 1, 18, 20, 18, 18, 18, 18, 18, 18, 18, 18, 1, 21, 22, 21, 23, 23, 1, 24, 1, 25, 26, 25, 27, 27, 27, 27, 27, 27, 27, 27, 27, 1, 25, 28, 25, 29, 29, 1, 30, 31, 30, 23, 23, 1, 32, 22, 32, 23, 23, 1, 33, 33, 33, 33, 33, 33, 33, 33, 33, 1, 34, 33, 33, 33, 33, 33, 33, 33, 33, 33, 1, 35, 35, 35, 35, 35, 35, 35, 35, 1, 36, 35, 35, 35, 35, 35, 35, 35, 35, 1, 37, 1, 38, 1, 39, 1, 40, 1, 41, 1, 42, 1, 43, 1, 44, 1, 45, 1, 46, 1, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 1, 49, 1, 48, 50, 48, 48, 48, 48, 48, 48, 48, 48, 1, 51, 52, 51, 53, 53, 1, 54, 1, 55, 56, 55, 57, 57, 57, 57, 57, 57, 57, 57, 57, 1, 55, 58, 55, 59, 59, 1, 60, 61, 60, 53, 53, 1, 62, 52, 62, 53, 53, 1, 1, 1, 0};
    }

    private static byte[] init__http_trans_targs_0() {
        return new byte[]{2, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 48, 19, 19, 20, 23, 21, 22, 17, 18, 20, 23, 24, 20, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 49, 42, 42, 43, 46, 44, 45, 40, 41, 43, 46, 47, 43, 47};
    }

    private static byte[] init__http_trans_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 3, 0, 5, 0, 7, 7, 7, 0, 1, 13, 0, 0, 1, 17, 21, 0, 0, 1, 0, 0, 23, 31, 19, 28, 25, 9, 1, 1, 11, 1, 15, 0, 0, 0, 0, 0, 3, 0, 5, 0, 0, 0, 1, 17, 21, 0, 0, 1, 0, 0, 23, 31, 19, 28, 25, 9, 1};
    }

    private static /* synthetic */ List lambda$parse$0(String n) {
        return new ArrayList();
    }
}

