/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSocketFactory;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCompression;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;

public class WarcWriter
implements Closeable {
    private static final byte[] TRAILER = new byte[]{13, 10, 13, 10};
    private final WritableByteChannel channel;
    private final WarcCompression compression;
    private final ByteBuffer buffer = ByteBuffer.allocate(8192);
    private AtomicLong position = new AtomicLong(0L);

    public WarcWriter(WritableByteChannel channel, WarcCompression compression) throws IOException {
        if (compression == WarcCompression.GZIP) {
            throw new UnsupportedOperationException("Writing of GZIP WARC files is not currently supported");
        }
        this.channel = channel;
        this.compression = compression;
        if (channel instanceof SeekableByteChannel) {
            this.position.set(((SeekableByteChannel)channel).position());
        }
    }

    public WarcWriter(WritableByteChannel channel) throws IOException {
        this(channel, WarcCompression.NONE);
    }

    public WarcWriter(OutputStream stream) throws IOException {
        this(Channels.newChannel(stream));
    }

    public synchronized void write(WarcRecord record) throws IOException {
        this.position.addAndGet(this.channel.write(ByteBuffer.wrap(record.serializeHeader())));
        MessageBody body = record.body();
        while (body.read(this.buffer) >= 0) {
            this.buffer.flip();
            this.position.addAndGet(this.channel.write(this.buffer));
            this.buffer.compact();
        }
        this.position.addAndGet(this.channel.write(ByteBuffer.wrap(TRAILER)));
    }

    public void fetch(URI uri) throws IOException {
        HttpRequest httpRequest = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)new HttpRequest.Builder("GET", uri.getRawPath()).version(MessageVersion.HTTP_1_0)).addHeader("Host", uri.getHost())).addHeader("User-Agent", "jwarc")).addHeader("Connection", "close")).build();
        Path tempPath = Files.createTempFile("jwarc", ".tmp", new FileAttribute[0]);
        try (FileChannel tempFile = FileChannel.open(tempPath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.TRUNCATE_EXISTING);){
            InetAddress ip;
            Instant date = Instant.now();
            try (Socket socket = WarcWriter.connect(uri.getScheme(), uri.getHost(), uri.getPort());){
                ip = ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress();
                socket.getOutputStream().write(httpRequest.serializeHeader());
                IOUtils.copy(socket.getInputStream(), Channels.newOutputStream(tempFile));
            }
            tempFile.position(0L);
            WarcRequest request = ((WarcRequest.Builder)((WarcRequest.Builder)new WarcRequest.Builder(uri).date(date)).body(httpRequest).ipAddress(ip)).build();
            WarcResponse response = ((WarcResponse.Builder)((WarcResponse.Builder)((WarcResponse.Builder)((WarcResponse.Builder)new WarcResponse.Builder(uri).date(date)).body(MediaType.HTTP_RESPONSE, tempFile, tempFile.size())).concurrentTo(request.id())).ipAddress(ip)).build();
            this.write(request);
            this.write(response);
        }
    }

    private static Socket connect(String scheme, String host, int port) throws IOException {
        Objects.requireNonNull(host);
        if ("http".equalsIgnoreCase(scheme)) {
            return new Socket(host, port < 0 ? 80 : port);
        }
        if ("https".equalsIgnoreCase(scheme)) {
            return SSLSocketFactory.getDefault().createSocket(host, port < 0 ? 443 : port);
        }
        throw new IllegalArgumentException("Unsupported URI scheme: " + scheme);
    }

    public long position() {
        return this.position.get();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

