/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.ReplayServer;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcWriter;

public class WarcTool {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            WarcTool.usage();
            return;
        }
        Command cmd = Command.valueOf(args[0]);
        cmd.exec(Arrays.copyOfRange(args, 1, args.length));
    }

    private static void usage() {
        System.err.println("usage: jwarc command [args]\n\nCommands:\n");
        for (Command cmd : Command.values()) {
            System.err.format("    %-10s %s\n", cmd.name(), cmd.help);
        }
    }

    private static enum Command {
        cdx("List records in CDX format"){

            @Override
            void exec(String[] args) throws Exception {
                DateTimeFormatter arcDate = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
                for (String arg : args) {
                    try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                        WarcRecord record = reader.next().orElse(null);
                        while (record != null) {
                            if ((record instanceof WarcResponse || record instanceof WarcResource) && ((WarcCaptureRecord)record).payload().isPresent()) {
                                MediaType type;
                                WarcPayload payload = ((WarcCaptureRecord)record).payload().get();
                                try {
                                    type = payload.type().base();
                                }
                                catch (IllegalArgumentException e) {
                                    type = MediaType.OCTET_STREAM;
                                }
                                URI uri = ((WarcCaptureRecord)record).targetURI();
                                String date = arcDate.format(record.date());
                                int status = record instanceof WarcResponse ? ((WarcResponse)record).http().status() : 200;
                                String digest = payload.digest().map(WarcDigest::toBase32).orElse("-");
                                long position = reader.position();
                                record = reader.next().orElse(null);
                                long length = reader.position() - position;
                                System.out.printf("%s %s %s %s %d %s - - %d %d %s%n", uri, date, uri, type, status, digest, length, position, arg);
                                continue;
                            }
                            record = reader.next().orElse(null);
                        }
                    }
                }
            }
        }
        ,
        fetch("Download a URL recording the request and response"){

            @Override
            void exec(String[] args) throws IOException, URISyntaxException {
                try (WarcWriter writer = new WarcWriter(System.out);){
                    for (String arg : args) {
                        writer.fetch(new URI(arg));
                    }
                }
            }
        }
        ,
        ls("List records in WARC file(s)"){

            @Override
            void exec(String[] args) throws IOException {
                for (String arg : args) {
                    try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                        for (WarcRecord record : reader) {
                            System.out.println(record);
                        }
                    }
                }
            }
        }
        ,
        screenshot("Take a screenshot of each page in the given WARCs"){

            @Override
            void exec(String[] args) throws Exception {
                ExecutorService serverThread = Executors.newSingleThreadExecutor();
                List<Path> warcs = Stream.of(args).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
                try (WarcWriter warcWriter = new WarcWriter(System.out);
                     ServerSocket serverSocket = new ServerSocket(0, -1, InetAddress.getLoopbackAddress());){
                    ReplayServer replayServer = new ReplayServer(serverSocket, warcs);
                    InetSocketAddress address = (InetSocketAddress)serverSocket.getLocalSocketAddress();
                    System.err.println("Replay proxy listening on " + address);
                    serverThread.execute(() -> {
                        try {
                            replayServer.listen();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                    for (String arg : args) {
                        try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                            for (WarcRecord record : reader) {
                                if (!this.isNormalPage(record)) continue;
                                WarcCaptureRecord capture = (WarcCaptureRecord)record;
                                this.screenshot(address, capture, warcWriter);
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void screenshot(InetSocketAddress proxy, WarcCaptureRecord capture, WarcWriter warcWriter) throws IOException, InterruptedException {
                Path screenshot = Files.createTempFile("jwarc-screenshot", ".png", new FileAttribute[0]);
                try {
                    String url = capture.targetURI().toString();
                    CharSequence[] cmd = new String[]{System.getenv().getOrDefault("BROWSER", "google-chrome"), "--headless", "--disable-gpu", "--disable-breakpad", "--ignore-certificate-errors", "--proxy-server=" + proxy.getHostString() + ":" + proxy.getPort(), "--hide-scrollbars", "--screenshot=" + screenshot, url};
                    System.err.println(String.join((CharSequence)" ", cmd));
                    Process p = new ProcessBuilder((String[])cmd).inheritIO().redirectOutput(new File(System.getProperty("os.name").startsWith("Windows") ? "NUL" : "/dev/null")).start();
                    p.waitFor();
                    try (FileChannel channel = FileChannel.open(screenshot, new OpenOption[0]);){
                        long size = channel.size();
                        if (size == 0L) {
                            return;
                        }
                        warcWriter.write(((WarcResource.Builder)((WarcResource.Builder)new WarcResource.Builder(URI.create("screenshot:" + url)).date(capture.date())).body(MediaType.parse("image/png"), channel, size)).build());
                    }
                }
                finally {
                    Files.deleteIfExists(screenshot);
                }
            }

            private boolean isNormalPage(WarcRecord record) throws IOException {
                if (!(record instanceof WarcResponse) && !(record instanceof WarcResource)) {
                    return false;
                }
                WarcCaptureRecord capture = (WarcCaptureRecord)record;
                String scheme = capture.targetURI().getScheme();
                if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                    return false;
                }
                try {
                    if (!capture.payload().isPresent() || !capture.payload().get().type().base().equals(MediaType.HTML)) {
                        return false;
                    }
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
                return !(capture instanceof WarcResponse) || ((WarcResponse)capture).http().status() == 200;
            }
        }
        ,
        serve("Serve WARC files with a basic replay server/proxy"){

            @Override
            void exec(String[] args) throws Exception {
                if (args.length == 0) {
                    System.err.println("Usage: WarcTool serve <warc-files>");
                    System.err.println("Obeys environment variable PORT.");
                    System.exit(1);
                }
                List<Path> warcs = Stream.of(args).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
                int port = Integer.parseInt(System.getenv().getOrDefault("PORT", "8080"));
                ReplayServer server = new ReplayServer(new ServerSocket(port), warcs);
                System.err.println("Listening on port " + port);
                server.listen();
            }
        };

        private final String help;

        private Command(String help) {
            this.help = help;
        }

        abstract void exec(String[] var1) throws Exception;
    }
}

