/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;

public class WarcRequest
extends WarcCaptureRecord {
    private HttpRequest http;

    WarcRequest(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public HttpRequest http() throws IOException {
        if (this.http == null) {
            this.http = HttpRequest.parse(this.body());
        }
        return this.http;
    }

    @Override
    public MediaType payloadType() throws IOException {
        return this.http().contentType();
    }

    @Override
    public Optional<WarcPayload> payload() throws IOException {
        if (this.contentType().base().equals(MediaType.HTTP)) {
            return Optional.of(new WarcPayload(this.http().body()){

                @Override
                MediaType type() {
                    return WarcRequest.this.http.contentType();
                }

                @Override
                Optional<MediaType> identifiedType() {
                    return WarcRequest.this.identifiedPayloadType();
                }

                @Override
                Optional<WarcDigest> digest() {
                    return WarcRequest.this.payloadDigest();
                }
            });
        }
        return Optional.empty();
    }

    public static class Builder
    extends WarcCaptureRecord.AbstractBuilder<WarcRequest, Builder> {
        public Builder(URI targetURI) {
            super("request");
            this.setHeader("WARC-Target-URI", targetURI.toString());
        }

        @Override
        public WarcRequest build() {
            return this.build(WarcRequest::new);
        }

        public Builder body(HttpRequest httpRequest) {
            return (Builder)this.body(MediaType.HTTP_REQUEST, httpRequest);
        }
    }
}

