/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.net.URI;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.netpreserve.jwarc.Message;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcTruncationReason;

public class WarcRecord
extends Message {
    WarcRecord(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    static URI parseRecordID(String uri) {
        if (uri.startsWith("<") && uri.endsWith(">")) {
            uri = uri.substring(1, uri.length() - 1);
        }
        return URI.create(uri);
    }

    private static String formatId(UUID recordId) {
        return "<urn:uuid:" + recordId + ">";
    }

    static String formatId(URI recordId) {
        return "<" + recordId + ">";
    }

    public String type() {
        return this.headers().sole("WARC-Type").get();
    }

    public URI id() {
        return WarcRecord.parseRecordID(this.headers().sole("WARC-Record-ID").get());
    }

    public Instant date() {
        return Instant.parse(this.headers().sole("WARC-Date").get());
    }

    public WarcTruncationReason truncated() {
        return this.headers().sole("WARC-Truncated").map(value -> WarcTruncationReason.valueOf(value.toUpperCase())).orElse(WarcTruncationReason.NOT_TRUNCATED);
    }

    public Optional<Long> segmentNumber() {
        return this.headers().sole("WARC-Segment-Number").map(Long::valueOf);
    }

    public Optional<WarcDigest> blockDigest() {
        return this.headers().sole("WARC-Block-Digest").map(WarcDigest::new);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.id() + "]";
    }

    public static abstract class AbstractBuilder<R extends WarcRecord, B extends AbstractBuilder<R, B>>
    extends Message.AbstractBuilder<R, B> {
        public AbstractBuilder(String type) {
            super(MessageVersion.WARC_1_1);
            this.setHeader("WARC-Type", type);
            this.setHeader("Content-Length", "0");
            this.date(Instant.now());
            this.recordId(UUID.randomUUID());
        }

        public B recordId(UUID uuid) {
            return (B)((AbstractBuilder)this.setHeader("WARC-Record-ID", WarcRecord.formatId(uuid)));
        }

        public B recordId(URI recordId) {
            return (B)((AbstractBuilder)this.setHeader("WARC-Record-ID", WarcRecord.formatId(recordId)));
        }

        public B date(Instant date) {
            return (B)((AbstractBuilder)this.setHeader("WARC-Date", date.toString()));
        }

        public B blockDigest(String algorithm, String value) {
            return this.blockDigest(new WarcDigest(algorithm, value));
        }

        public B blockDigest(WarcDigest digest) {
            return (B)((AbstractBuilder)this.addHeader("WARC-Block-Digest", digest.toPrefixedBase32()));
        }

        public B truncated(WarcTruncationReason truncationReason) {
            if (truncationReason.equals((Object)WarcTruncationReason.NOT_TRUNCATED)) {
                this.headerMap.remove("WARC-Truncated");
                return (B)this;
            }
            return (B)((AbstractBuilder)this.addHeader("WARC-Truncated", truncationReason.name().toLowerCase()));
        }

        public B segmentNumber(long segmentNumber) {
            return (B)((AbstractBuilder)this.addHeader("WARC-Segment-Number", String.valueOf(segmentNumber)));
        }

        protected R build(Constructor<R> constructor) {
            MessageHeaders headers = new MessageHeaders(this.headerMap);
            return constructor.construct(this.version, headers, this.makeBody());
        }
    }

    @FunctionalInterface
    public static interface Constructor<R extends WarcRecord> {
        public R construct(MessageVersion var1, MessageHeaders var2, MessageBody var3);
    }
}

