/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.netpreserve.jwarc.GunzipChannel;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.ParsingException;
import org.netpreserve.jwarc.WarcCompression;
import org.netpreserve.jwarc.WarcContinuation;
import org.netpreserve.jwarc.WarcConversion;
import org.netpreserve.jwarc.WarcMetadata;
import org.netpreserve.jwarc.WarcParser;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcRevisit;
import org.netpreserve.jwarc.Warcinfo;

public class WarcReader
implements Iterable<WarcRecord>,
Closeable {
    private static final int CRLFCRLF = 0xD0A0D0A;
    private static final Map<String, WarcRecord.Constructor> defaultTypes = WarcReader.initDefaultTypes();
    private final HashMap<String, WarcRecord.Constructor> types;
    private final WarcParser parser = new WarcParser();
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer;
    private final WarcCompression compression;
    private WarcRecord record;
    private final long startPosition;
    private long position;
    private long headerLength;

    public WarcReader(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        this.types = new HashMap<String, WarcRecord.Constructor>(defaultTypes);
        this.startPosition = channel instanceof SeekableByteChannel ? ((SeekableByteChannel)channel).position() : 0L;
        this.position = this.startPosition;
        while (buffer.remaining() < 2) {
            buffer.compact();
            int n = channel.read(buffer);
            buffer.flip();
            if (n >= 0) continue;
            if (!buffer.hasRemaining()) {
                this.channel = channel;
                this.buffer = buffer;
                this.compression = WarcCompression.NONE;
                return;
            }
            throw new EOFException();
        }
        if (buffer.getShort(buffer.position()) == 8075) {
            this.channel = new GunzipChannel(channel, buffer);
            this.buffer = ByteBuffer.allocate(8192);
            this.buffer.flip();
            this.compression = WarcCompression.GZIP;
        } else {
            this.channel = channel;
            this.buffer = buffer;
            this.compression = WarcCompression.NONE;
        }
    }

    public WarcReader(ReadableByteChannel channel) throws IOException {
        this(channel, (ByteBuffer)ByteBuffer.allocate(8192).flip());
    }

    public WarcReader(InputStream stream) throws IOException {
        this(Channels.newChannel(stream));
    }

    public WarcReader(Path path) throws IOException {
        this(FileChannel.open(path, new OpenOption[0]));
    }

    private static Map<String, WarcRecord.Constructor> initDefaultTypes() {
        HashMap<String, WarcRecord.Constructor> types = new HashMap<String, WarcRecord.Constructor>();
        types.put("default", WarcRecord::new);
        types.put("continuation", WarcContinuation::new);
        types.put("conversion", WarcConversion::new);
        types.put("metadata", WarcMetadata::new);
        types.put("request", WarcRequest::new);
        types.put("resource", WarcResource::new);
        types.put("response", WarcResponse::new);
        types.put("revisit", WarcRevisit::new);
        types.put("warcinfo", Warcinfo::new);
        return types;
    }

    public Optional<WarcRecord> next() throws IOException {
        if (this.record != null) {
            this.record.body().consume();
            this.record.body().close();
            this.consumeTrailer();
            this.position = this.channel instanceof GunzipChannel ? this.startPosition + ((GunzipChannel)this.channel).inputPosition() : (this.position += this.headerLength + this.record.body().size() + 4L);
        }
        this.parser.reset();
        if (!this.parser.parse(this.channel, this.buffer)) {
            return Optional.empty();
        }
        this.headerLength = this.parser.position();
        MessageHeaders headers = this.parser.headers();
        long contentLength = headers.sole("Content-Length").map(Long::parseLong).orElse(0L);
        MessageBody body = new MessageBody(this.channel, this.buffer, contentLength);
        this.record = this.construct(this.parser.version(), headers, body);
        return Optional.of(this.record);
    }

    private WarcRecord construct(MessageVersion version, MessageHeaders headers, MessageBody body) {
        String type = headers.sole("WARC-Type").orElse("default");
        WarcRecord.Constructor constructor = this.types.get(type);
        if (constructor == null) {
            constructor = this.types.get("default");
        }
        return constructor.construct(version, headers, body);
    }

    private void consumeTrailer() throws IOException {
        if (this.record.version().getProtocol().equals("ARC")) {
            while (this.buffer.remaining() < 1) {
                this.buffer.compact();
                if (this.channel.read(this.buffer) < 0) {
                    throw new EOFException("expected trailing LF");
                }
                this.buffer.flip();
            }
            byte trailer = this.buffer.get();
            if (trailer != 10) {
                throw new ParsingException("invalid ARC trailer: " + Integer.toHexString(trailer));
            }
        } else {
            while (this.buffer.remaining() < 4) {
                this.buffer.compact();
                if (this.channel.read(this.buffer) < 0) {
                    throw new EOFException("expected trailing CRLFCRLF");
                }
                this.buffer.flip();
            }
            int trailer = this.buffer.getInt();
            if (trailer != 0xD0A0D0A) {
                throw new ParsingException("invalid WARC trailer: " + Integer.toHexString(trailer));
            }
        }
    }

    public void registerType(String type, WarcRecord.Constructor<WarcRecord> constructor) {
        this.types.put(type, constructor);
    }

    public long position() {
        return this.position;
    }

    public WarcCompression compression() {
        return this.compression;
    }

    @Override
    public Iterator<WarcRecord> iterator() {
        return new Iterator<WarcRecord>(){
            WarcRecord next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = WarcReader.this.next().orElse(null);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                return this.next != null;
            }

            @Override
            public WarcRecord next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                WarcRecord temp = this.next;
                this.next = null;
                return temp;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

