/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcPayload;

public class WarcMetadata
extends WarcCaptureRecord {
    private MessageHeaders fields;

    WarcMetadata(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    @Override
    public Optional<WarcPayload> payload() throws IOException {
        return Optional.empty();
    }

    public MessageHeaders fields() throws IOException {
        if (this.fields == null) {
            this.fields = MessageHeaders.parse(this.body());
        }
        return this.fields;
    }

    public static class Builder
    extends WarcCaptureRecord.AbstractBuilder<WarcMetadata, Builder> {
        protected Builder() {
            super("metadata");
        }

        @Override
        public WarcMetadata build() {
            return this.build(WarcMetadata::new);
        }

        public Builder fields(Map<String, List<String>> map) {
            return (Builder)this.body(MediaType.WARC_FIELDS, MessageHeaders.format(map).getBytes(StandardCharsets.UTF_8));
        }
    }
}

