/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.InetAddresses;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.Message;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcTargetRecord;

public abstract class WarcCaptureRecord
extends WarcTargetRecord {
    WarcCaptureRecord(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public Optional<InetAddress> ipAddress() {
        return this.headers().sole("WARC-IP-Address").map(InetAddresses::forString);
    }

    public List<URI> concurrentTo() {
        return this.headers().all("WARC-Concurrent-To").stream().map(WarcRecord::parseRecordID).collect(Collectors.toList());
    }

    public MediaType payloadType() throws IOException {
        return this.contentType();
    }

    public static abstract class AbstractBuilder<R extends WarcCaptureRecord, B extends AbstractBuilder<R, B>>
    extends WarcTargetRecord.Builder<R, B> {
        protected AbstractBuilder(String type) {
            super(type);
        }

        public B body(MediaType type, Message message) {
            ByteBuffer header = ByteBuffer.wrap(message.serializeHeader());
            ReadableByteChannel channel = IOUtils.prefixChannel(header, message.body());
            return (B)((AbstractBuilder)this.body(type, channel, message.body().size() + (long)header.remaining()));
        }

        public B concurrentTo(URI recordId) {
            return (B)((AbstractBuilder)this.addHeader("WARC-Concurrent-To", recordId.toString()));
        }

        public B ipAddress(InetAddress ipAddress) {
            return (B)((AbstractBuilder)this.addHeader("WARC-IP-Address", ipAddress.getHostAddress()));
        }
    }
}

