/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import org.netpreserve.jwarc.CertificateAuthority;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.IOUtils;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;

class ReplayServer {
    private static final MediaType HTML = MediaType.parse("text/html");
    private final ServerSocket serverSocket;
    private String firstUrl = null;
    private final Map<String, IndexEntry> index = new HashMap<String, IndexEntry>();
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    private byte[] script = "<!doctype html><script src='/__jwarc__/inject.js'></script>".getBytes(StandardCharsets.US_ASCII);
    private CertificateAuthority ca;

    ReplayServer(ServerSocket serverSocket, List<Path> warcs) throws IOException {
        this.serverSocket = serverSocket;
        for (Path warc : warcs) {
            this.index(warc);
        }
    }

    private void index(Path warcFile) throws IOException {
        try (WarcReader reader = new WarcReader(warcFile);){
            for (WarcRecord record : reader) {
                WarcCaptureRecord capture;
                String scheme;
                if (!(record instanceof WarcResponse) && !(record instanceof WarcResource) || !"http".equalsIgnoreCase(scheme = (capture = (WarcCaptureRecord)record).targetURI().getScheme()) && !"https".equalsIgnoreCase(scheme)) continue;
                String url = capture.targetURI().toString();
                this.index.put(url, new IndexEntry(warcFile, reader.position()));
                if (this.firstUrl != null || !HTML.equals(capture.payloadType().base())) continue;
                this.firstUrl = url;
            }
        }
    }

    void listen() throws IOException {
        while (!this.serverSocket.isClosed()) {
            Socket socket = this.serverSocket.accept();
            this.threadPool.execute(() -> this.interact(socket, ""));
        }
    }

    /*
     * Exception decompiling
     */
    private void interact(Socket socket, String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handle(Socket socket, String prefix, HttpRequest request) throws Exception {
        String target = prefix + request.target();
        if (request.method().equals("CONNECT")) {
            this.send(socket, new HttpResponse.Builder(200, "OK").build());
            this.upgradeToTls(socket, target);
        } else if (target.equals("/")) {
            this.send(socket, ((HttpResponse.Builder)((HttpResponse.Builder)new HttpResponse.Builder(307, "Redirect").addHeader("Connection", "close")).addHeader("Location", "/replay/12345678901234/" + this.firstUrl)).build());
        } else if (target.equals("/__jwarc__/sw.js")) {
            this.listen(socket, "sw.js");
        } else if (target.equals("/__jwarc__/inject.js")) {
            this.listen(socket, "inject.js");
        } else if (target.startsWith("/replay/")) {
            int i;
            if (!request.headers().first("x-serviceworker").isPresent()) {
                this.send(socket, ((HttpResponse.Builder)((HttpResponse.Builder)new HttpResponse.Builder(200, "OK").body(HTML, this.script)).setHeader("Connection", "close")).build());
            }
            if ((i = target.indexOf(47, "/replay/".length())) != -1) {
                target = target.substring(i + 1);
            }
            this.replay(socket, target);
        } else {
            this.replay(socket, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeToTls(Socket socket, String target) throws Exception {
        ReplayServer replayServer = this;
        synchronized (replayServer) {
            if (this.ca == null) {
                this.ca = new CertificateAuthority(new X500Principal("cn=Dummy CA"));
            }
        }
        final String host = target.replaceFirst(":[0-9]+$", "");
        final X509Certificate cert = this.ca.generateCertificate(new X500Principal("cn=" + host));
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(new KeyManager[]{new X509KeyManager(){

            @Override
            public X509Certificate[] getCertificateChain(String alias) {
                return new X509Certificate[]{cert, ((ReplayServer)ReplayServer.this).ca.caCert};
            }

            @Override
            public PrivateKey getPrivateKey(String s) {
                return ((ReplayServer)ReplayServer.this).ca.subKeyPair.getPrivate();
            }

            @Override
            public String[] getClientAliases(String s, Principal[] principals) {
                throw new IllegalStateException();
            }

            @Override
            public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                throw new IllegalStateException();
            }

            @Override
            public String[] getServerAliases(String s, Principal[] principals) {
                return new String[]{host};
            }

            @Override
            public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                return host;
            }
        }}, null, null);
        SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(socket, null, true);
        sslSocket.setUseClientMode(false);
        sslSocket.startHandshake();
        this.interact(sslSocket, "https://" + target.replaceFirst(":443$", ""));
    }

    private void replay(Socket socket, String target) throws IOException {
        IndexEntry entry = this.index.get(target);
        if (entry != null) {
            try (FileChannel channel = FileChannel.open(entry.file, StandardOpenOption.READ);){
                channel.position(entry.position);
                WarcReader reader = new WarcReader(channel);
                HttpResponse http = ((WarcResponse)reader.next().get()).http();
                HttpResponse.Builder b = new HttpResponse.Builder(http.status(), http.reason());
                for (Map.Entry<String, List<String>> e : http.headers().map().entrySet()) {
                    for (String value : e.getValue()) {
                        b.addHeader(e.getKey(), value);
                    }
                }
                b.setHeader("Connection", "keep-alive");
                MessageBody body = http.body();
                if (HTML.equals(http.contentType().base())) {
                    body = new MessageBody(body, ByteBuffer.wrap(this.script), (long)this.script.length + body.size());
                }
                b.body(http.contentType(), body, body.size());
                this.send(socket, b.build());
            }
        } else {
            this.send(socket, ((HttpResponse.Builder)((HttpResponse.Builder)new HttpResponse.Builder(404, "Not found").body(HTML, "Not found".getBytes(StandardCharsets.UTF_8))).setHeader("Connection", "keep-alive")).build());
        }
    }

    private void listen(Socket socket, String resource) throws IOException {
        URLConnection conn = this.getClass().getResource(resource).openConnection();
        try (InputStream stream = conn.getInputStream();){
            this.send(socket, ((HttpResponse.Builder)((HttpResponse.Builder)((HttpResponse.Builder)new HttpResponse.Builder(200, "OK").body(MediaType.parse("application/javascript"), Channels.newChannel(stream), conn.getContentLengthLong())).setHeader("Connection", "close")).setHeader("Service-Worker-Allowed", "/")).build());
        }
    }

    private void send(Socket socket, HttpResponse response) throws IOException {
        try {
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write(response.serializeHeader());
            IOUtils.copy(response.body().stream(), outputStream);
        }
        catch (SocketException | SSLProtocolException e) {
            socket.close();
        }
    }

    private static class IndexEntry {
        private final Path file;
        private final long position;

        IndexEntry(Path file, long position) {
            this.file = file;
            this.position = position;
        }
    }
}

