/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.netpreserve.jwarc.IOUtils;

public class MessageBody
implements ReadableByteChannel {
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer;
    private final long size;
    private long position = 0L;
    private boolean open = true;

    MessageBody(ReadableByteChannel channel, ByteBuffer buffer, long size) {
        this.channel = channel;
        this.buffer = buffer;
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dest) throws IOException {
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (this.position >= this.size) {
            return -1;
        }
        if (this.buffer.hasRemaining()) {
            int n = IOUtils.transfer(this.buffer, dest, this.size - this.position);
            this.position += (long)n;
            return n;
        }
        int savedLimit = dest.limit();
        try {
            dest.limit(dest.position() + (int)Math.min((long)dest.remaining(), this.size - this.position));
            int actuallyRead = this.channel.read(dest);
            if (actuallyRead < 0) {
                throw new EOFException("expected " + (this.size - this.position) + " more bytes in file");
            }
            this.position += (long)actuallyRead;
            int n = actuallyRead;
            return n;
        }
        finally {
            dest.limit(savedLimit);
        }
    }

    void consume() throws IOException {
        while (true) {
            long remaining;
            if ((remaining = this.size - this.position) <= (long)this.buffer.remaining()) {
                this.buffer.position(this.buffer.position() + (int)remaining);
                this.position = this.size;
                break;
            }
            if (this.channel instanceof SeekableByteChannel) {
                SeekableByteChannel seekable = (SeekableByteChannel)this.channel;
                seekable.position(seekable.position() + remaining - (long)this.buffer.remaining());
                this.position = this.size;
                this.buffer.position(this.buffer.limit());
                break;
            }
            this.position += (long)this.buffer.remaining();
            this.buffer.clear();
            if (this.channel.read(this.buffer) < 0) {
                throw new EOFException();
            }
            this.buffer.flip();
        }
    }

    @Override
    public boolean isOpen() {
        return this.open && this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    public long size() {
        return this.size;
    }

    public long position() {
        return this.position;
    }

    public InputStream stream() {
        return new Stream();
    }

    public static MessageBody empty() {
        return new MessageBody(Channels.newChannel(new ByteArrayInputStream(new byte[0])), ByteBuffer.allocate(0), 0L);
    }

    private class Stream
    extends InputStream {
        private Stream() {
        }

        @Override
        public int read(byte[] b) throws IOException {
            return MessageBody.this.read(ByteBuffer.wrap(b));
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return MessageBody.this.read(ByteBuffer.wrap(b, off, len));
        }

        @Override
        public int available() {
            return (int)Math.min(MessageBody.this.position - MessageBody.this.size, Integer.MAX_VALUE);
        }

        @Override
        public void close() throws IOException {
            MessageBody.this.close();
        }

        @Override
        public int read() throws IOException {
            if (!MessageBody.this.open) {
                throw new ClosedChannelException();
            }
            if (MessageBody.this.position >= MessageBody.this.size) {
                return -1;
            }
            while (!MessageBody.this.buffer.hasRemaining()) {
                MessageBody.this.buffer.compact();
                if (MessageBody.this.channel.read(MessageBody.this.buffer) < 0) {
                    throw new EOFException();
                }
                MessageBody.this.buffer.flip();
            }
            MessageBody.this.position++;
            return MessageBody.this.buffer.get();
        }
    }
}

