/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netpreserve.jwarc.HttpMessage;
import org.netpreserve.jwarc.HttpParser;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;

public class HttpResponse
extends HttpMessage {
    private final int status;
    private final String reason;

    HttpResponse(int status, String reason, MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
        this.status = status;
        this.reason = reason;
    }

    @Override
    void serializeHeaderTo(Appendable output) throws IOException {
        output.append(this.version().toString());
        output.append(' ');
        output.append(Integer.toString(this.status));
        output.append(' ');
        output.append(this.reason);
        output.append("\r\n");
        this.headers().appendTo(output);
        output.append("\r\n");
    }

    public static HttpResponse parse(ReadableByteChannel channel) throws IOException {
        long contentLength;
        MessageBody body;
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        buffer.flip();
        ParseHandler handler = new ParseHandler();
        HttpParser parser = new HttpParser(handler);
        parser.responseOnly();
        parser.parse(channel, buffer);
        MessageHeaders headers = new MessageHeaders(handler.headerMap);
        if (channel instanceof MessageBody) {
            body = (MessageBody)channel;
            contentLength = body.size() - body.position();
        } else {
            contentLength = headers.sole("Content-Length").map(Long::parseLong).orElse(0L);
        }
        body = new MessageBody(channel, buffer, contentLength);
        return new HttpResponse(handler.status, handler.reason, handler.version, headers, body);
    }

    public int status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public static class Builder
    extends HttpMessage.AbstractBuilder<HttpResponse, Builder> {
        private final int status;
        private final String reasonPhrase;

        public Builder(int status, String reasonPhrase) {
            this.status = status;
            this.reasonPhrase = reasonPhrase;
        }

        @Override
        public HttpResponse build() {
            return new HttpResponse(this.status, this.reasonPhrase, this.version, new MessageHeaders(this.headerMap), this.makeBody());
        }
    }

    private static class ParseHandler
    implements HttpParser.Handler {
        Map<String, List<String>> headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        private MessageVersion version;
        private String name;
        private int status;
        private String reason;

        private ParseHandler() {
        }

        @Override
        public void version(int major, int minor) {
            this.version = new MessageVersion("HTTP", major, minor);
        }

        @Override
        public void name(String name) {
            this.name = name;
        }

        @Override
        public void value(String value) {
            this.headerMap.computeIfAbsent(this.name, name -> new ArrayList()).add(value);
        }

        @Override
        public void reason(String reason) {
            this.reason = reason;
        }

        @Override
        public void status(int status) {
            this.status = status;
        }

        @Override
        public void target(String target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void method(String method) {
            throw new UnsupportedOperationException();
        }
    }
}

