/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netpreserve.jwarc.HttpMessage;
import org.netpreserve.jwarc.HttpParser;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;

public class HttpRequest
extends HttpMessage {
    private final String method;
    private final String target;

    HttpRequest(String method, String target, MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
        this.method = method;
        this.target = target;
    }

    public String target() {
        return this.target;
    }

    public String method() {
        return this.method;
    }

    @Override
    void serializeHeaderTo(Appendable output) throws IOException {
        output.append(this.method);
        output.append(' ');
        output.append(this.target);
        output.append(' ');
        output.append(this.version().toString());
        output.append("\r\n");
        this.headers().appendTo(output);
        output.append("\r\n");
    }

    public static HttpRequest parse(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        return HttpRequest.parse(channel, buffer);
    }

    static HttpRequest parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        buffer.flip();
        ParseHandler handler = new ParseHandler();
        HttpParser parser = new HttpParser(handler);
        parser.requestOnly();
        parser.parse(channel, buffer);
        MessageHeaders headers = new MessageHeaders(handler.headerMap);
        long contentLength = headers.sole("Content-Length").map(Long::parseLong).orElse(-1L);
        MessageBody body = new MessageBody(channel, buffer, contentLength);
        return new HttpRequest(handler.method, handler.target, handler.version, headers, body);
    }

    public static class Builder
    extends HttpMessage.AbstractBuilder<HttpRequest, Builder> {
        private final String method;
        private final String target;

        public Builder(String method, String target) {
            this.method = method;
            this.target = target;
        }

        @Override
        public HttpRequest build() {
            return new HttpRequest(this.method, this.target, this.version, new MessageHeaders(this.headerMap), this.makeBody());
        }
    }

    private static class ParseHandler
    implements HttpParser.Handler {
        Map<String, List<String>> headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        private MessageVersion version;
        private String name;
        private String method;
        private String target;

        private ParseHandler() {
        }

        @Override
        public void version(int major, int minor) {
            this.version = new MessageVersion("HTTP", major, minor);
        }

        @Override
        public void name(String name) {
            this.name = name;
        }

        @Override
        public void value(String value) {
            this.headerMap.computeIfAbsent(this.name, name -> new ArrayList()).add(value);
        }

        @Override
        public void method(String method) {
            this.method = method;
        }

        @Override
        public void reason(String reason) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void status(int status) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void target(String target) {
            this.target = target;
        }
    }
}

