/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.netpreserve.jwarc.ParsingException;

public class HttpParser {
    private final Handler handler;
    private int cs;
    private long position;
    private boolean finished;
    private byte[] buf = new byte[256];
    private int bufPos = 0;
    private int endOfText;
    private int major;
    private int minor;
    private int status;
    private static final byte[] _http_actions = HttpParser.init__http_actions_0();
    private static final short[] _http_key_offsets = HttpParser.init__http_key_offsets_0();
    private static final char[] _http_trans_keys = HttpParser.init__http_trans_keys_0();
    private static final byte[] _http_single_lengths = HttpParser.init__http_single_lengths_0();
    private static final byte[] _http_range_lengths = HttpParser.init__http_range_lengths_0();
    private static final short[] _http_index_offsets = HttpParser.init__http_index_offsets_0();
    private static final byte[] _http_indicies = HttpParser.init__http_indicies_0();
    private static final byte[] _http_trans_targs = HttpParser.init__http_trans_targs_0();
    private static final byte[] _http_trans_actions = HttpParser.init__http_trans_actions_0();
    static final int http_start = 1;
    static final int http_first_final = 48;
    static final int http_error = 0;
    static final int http_en_http_request = 25;
    static final int http_en_http_response = 1;

    public HttpParser(Handler handler) {
        this.handler = handler;
        this.reset();
    }

    public void reset() {
        this.cs = 1;
        this.bufPos = 0;
        if (this.buf.length > 8192) {
            this.buf = new byte[256];
        }
        this.major = 0;
        this.minor = 0;
        this.status = 0;
        this.endOfText = 0;
        this.position = 0L;
        this.finished = false;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isError() {
        return this.cs == 0;
    }

    public void requestOnly() {
        this.cs = 25;
    }

    public void responseOnly() {
        this.cs = 1;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(ByteBuffer data) {
        p = data.position();
        pe = data.limit();
        _trans = 0;
        _goto_targ = 0;
        block21: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block21;
                    }
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block21;
                    }
                }
                case 1: {
                    _keys = HttpParser._http_key_offsets[this.cs];
                    _trans = HttpParser._http_index_offsets[this.cs];
                    _klen = HttpParser._http_single_lengths[this.cs];
                    if (_klen <= 0) ** GOTO lbl33
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if (data.get(p) < HttpParser._http_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if (data.get(p) > HttpParser._http_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl47
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl33:
                    // 2 sources

                    if ((_klen = HttpParser._http_range_lengths[this.cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if (data.get(p) < HttpParser._http_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if (data.get(p) > HttpParser._http_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl47
                        }
                        _trans += _klen;
                    }
lbl47:
                    // 5 sources

                    _trans = HttpParser._http_indicies[_trans];
                    this.cs = HttpParser._http_trans_targs[_trans];
                    if (HttpParser._http_trans_actions[_trans] != 0) {
                        _acts = HttpParser._http_trans_actions[_trans];
                        _nacts = HttpParser._http_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (HttpParser._http_actions[_acts++]) {
                                case 0: {
                                    this.push(data.get(p));
                                    break;
                                }
                                case 1: {
                                    if (this.bufPos <= 0) break;
                                    this.push((byte)32);
                                    break;
                                }
                                case 2: {
                                    this.major = this.major * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 3: {
                                    this.minor = this.minor * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 4: {
                                    this.status = this.status * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 5: {
                                    this.endOfText = this.bufPos;
                                    break;
                                }
                                case 6: {
                                    this.handler.version(this.major, this.minor);
                                    break;
                                }
                                case 7: {
                                    this.handler.name(new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII));
                                    this.bufPos = 0;
                                    break;
                                }
                                case 8: {
                                    this.handler.method(new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII));
                                    this.bufPos = 0;
                                    break;
                                }
                                case 9: {
                                    this.handler.reason(new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1));
                                    this.bufPos = 0;
                                    break;
                                }
                                case 10: {
                                    this.handler.status(this.status);
                                    break;
                                }
                                case 11: {
                                    this.handler.target(new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1));
                                    this.bufPos = 0;
                                    break;
                                }
                                case 12: {
                                    this.handler.value(new String(this.buf, 0, this.endOfText, StandardCharsets.ISO_8859_1));
                                    this.bufPos = 0;
                                    this.endOfText = 0;
                                    break;
                                }
                                case 13: {
                                    this.finished = true;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block21;
                    }
                    if (++p == pe) break block21;
                    _goto_targ = 1;
                    continue block21;
                }
            }
            break;
        }
        this.position += (long)(p - data.position());
        data.position(p);
    }

    public void parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (true) {
            this.parse(buffer);
            if (this.isFinished()) break;
            if (this.isError()) {
                throw new ParsingException("invalid HTTP message at byte position " + this.position);
            }
            buffer.compact();
            int n = channel.read(buffer);
            if (n < 0) {
                throw new EOFException("state=" + this.cs);
            }
            buffer.flip();
        }
    }

    private void push(byte b) {
        if (this.bufPos >= this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
        }
        this.buf[this.bufPos++] = b;
    }

    private static byte[] init__http_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 2, 1, 0, 2, 5, 0, 2, 12, 0};
    }

    private static short[] init__http_key_offsets_0() {
        return new short[]{0, 0, 1, 2, 3, 4, 5, 7, 8, 10, 11, 13, 15, 17, 18, 24, 25, 41, 42, 58, 65, 66, 84, 91, 98, 105, 120, 136, 151, 167, 168, 169, 170, 171, 172, 174, 175, 177, 178, 179, 195, 196, 212, 219, 220, 238, 245, 252, 259, 259};
    }

    private static char[] init__http_trans_keys_0() {
        return new char[]{'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', ' ', '0', '9', '0', '9', '0', '9', ' ', '\t', '\r', ' ', '~', '\u0080', '\u00ff', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '$', '=', '_', '~', '&', '(', '*', ';', '?', 'Z', 'a', 'z', '\u0080', '\u00ff', ' ', '!', '$', '=', '_', '~', '&', '(', '*', ';', '?', 'Z', 'a', 'z', '\u0080', '\u00ff', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', '\r', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\u0000'};
    }

    private static byte[] init__http_single_lengths_0() {
        return new byte[]{0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 2, 1, 4, 1, 4, 3, 1, 6, 3, 3, 3, 3, 4, 5, 6, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 4, 1, 4, 3, 1, 6, 3, 3, 3, 0, 0};
    }

    private static byte[] init__http_range_lengths_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 2, 0, 6, 0, 6, 2, 0, 6, 2, 2, 2, 6, 6, 5, 5, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 6, 0, 6, 2, 0, 6, 2, 2, 2, 0, 0};
    }

    private static short[] init__http_index_offsets_0() {
        return new short[]{0, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 31, 33, 44, 46, 57, 63, 65, 78, 84, 90, 96, 106, 117, 128, 140, 142, 144, 146, 148, 150, 152, 154, 156, 158, 160, 171, 173, 184, 190, 192, 205, 211, 217, 223, 224};
    }

    private static byte[] init__http_indicies_0() {
        return new byte[]{0, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 1, 12, 1, 13, 1, 14, 15, 14, 14, 1, 16, 1, 17, 18, 18, 18, 18, 18, 18, 18, 18, 18, 1, 19, 1, 18, 20, 18, 18, 18, 18, 18, 18, 18, 18, 1, 21, 22, 21, 23, 23, 1, 24, 1, 25, 26, 25, 27, 27, 27, 27, 27, 27, 27, 27, 27, 1, 25, 28, 25, 29, 29, 1, 30, 31, 30, 23, 23, 1, 32, 22, 32, 23, 23, 1, 33, 33, 33, 33, 33, 33, 33, 33, 33, 1, 34, 33, 33, 33, 33, 33, 33, 33, 33, 33, 1, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 1, 36, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 1, 37, 1, 38, 1, 39, 1, 40, 1, 41, 1, 42, 1, 43, 1, 44, 1, 45, 1, 46, 1, 47, 48, 48, 48, 48, 48, 48, 48, 48, 48, 1, 49, 1, 48, 50, 48, 48, 48, 48, 48, 48, 48, 48, 1, 51, 52, 51, 53, 53, 1, 54, 1, 55, 56, 55, 57, 57, 57, 57, 57, 57, 57, 57, 57, 1, 55, 58, 55, 59, 59, 1, 60, 61, 60, 53, 53, 1, 62, 52, 62, 53, 53, 1, 1, 1, 0};
    }

    private static byte[] init__http_trans_targs_0() {
        return new byte[]{2, 0, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 14, 15, 16, 17, 18, 48, 19, 19, 20, 23, 21, 22, 17, 18, 20, 23, 24, 20, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 49, 42, 42, 43, 46, 44, 45, 40, 41, 43, 46, 47, 43, 47};
    }

    private static byte[] init__http_trans_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 5, 0, 7, 13, 9, 9, 9, 21, 1, 19, 0, 0, 1, 27, 15, 0, 0, 1, 0, 0, 25, 35, 3, 29, 32, 11, 1, 1, 17, 1, 23, 0, 0, 0, 0, 0, 5, 0, 7, 13, 0, 0, 1, 27, 15, 0, 0, 1, 0, 0, 25, 35, 3, 29, 32, 11, 1};
    }

    public static interface Handler {
        public void version(int var1, int var2);

        public void name(String var1);

        public void value(String var1);

        public void method(String var1);

        public void reason(String var1);

        public void status(int var1);

        public void target(String var1);
    }
}

