/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.x500.X500Principal;

class CertificateAuthority {
    private final KeyPair caKeyPair;
    final KeyPair subKeyPair;
    final X509Certificate caCert;
    AtomicInteger serial = new AtomicInteger((int)(System.currentTimeMillis() >> 8));

    CertificateAuthority(X500Principal caName) throws GeneralSecurityException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
        keyGen.initialize(256);
        this.caKeyPair = keyGen.generateKeyPair();
        this.subKeyPair = keyGen.generateKeyPair();
        this.caCert = CertificateAuthority.signCertificate(caName, this.caKeyPair.getPrivate(), caName, this.caKeyPair.getPublic(), this.serial.getAndIncrement(), true);
    }

    X509Certificate generateCertificate(X500Principal subject) throws GeneralSecurityException {
        return CertificateAuthority.signCertificate(this.caCert.getSubjectX500Principal(), this.caKeyPair.getPrivate(), subject, this.subKeyPair.getPublic(), this.serial.getAndIncrement(), false);
    }

    private static X509Certificate signCertificate(X500Principal issuer, PrivateKey issuerKey, X500Principal subject, PublicKey subjectKey, int serial, boolean isCA) throws GeneralSecurityException {
        byte[] algorithm = new byte[]{48, 12, 6, 8, 42, -122, 72, -50, 61, 4, 3, 2, 5, 0};
        byte[] preamble = new byte[]{-96, 3, 2, 1, 2};
        byte[] serialBytes = new byte[]{2, 4, (byte)(serial >> 24), (byte)(serial >> 16), (byte)(serial >> 8), (byte)serial};
        byte[] validity = new byte[]{48, 30, 23, 13, 49, 57, 48, 50, 49, 49, 48, 55, 49, 55, 51, 48, 90, 23, 13, 51, 52, 48, 50, 49, 49, 48, 55, 49, 55, 51, 48, 90};
        byte[] constraints = isCA ? new byte[]{-93, 22, 48, 20, 48, 18, 6, 3, 85, 29, 19, 1, 1, -1, 4, 8, 48, 6, 1, 1, -1, 2, 1, 12} : new byte[]{};
        byte[] rawCert = CertificateAuthority.derSequence(preamble, serialBytes, algorithm, issuer.getEncoded(), validity, subject.getEncoded(), subjectKey.getEncoded(), constraints);
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initSign(issuerKey);
        signature.update(rawCert);
        byte[] sigBytes = signature.sign();
        byte[] cert = CertificateAuthority.derSequence(rawCert, algorithm, {3, (byte)(sigBytes.length + 1), 0}, sigBytes);
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(cert));
    }

    private static byte[] derSequence(byte[] ... arrays) {
        int len = 0;
        for (byte[] a : arrays) {
            len += a.length;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(48);
            baos.write(CertificateAuthority.derLength(len));
            for (byte[] a : arrays) {
                baos.write(a);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new UncheckedIOException("impossible", e);
        }
    }

    private static byte[] derLength(int len) {
        if (len < 128) {
            return new byte[]{(byte)len};
        }
        if (len < 256) {
            return new byte[]{-127, (byte)len};
        }
        if (len < 65536) {
            return new byte[]{-126, (byte)(len >> 8), (byte)len};
        }
        throw new IllegalArgumentException("too large");
    }
}

