/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Arrays;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcWriter;

public class WarcTool {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            WarcTool.usage();
            return;
        }
        Command cmd = Command.valueOf(args[0]);
        cmd.exec(Arrays.copyOfRange(args, 1, args.length));
    }

    private static void usage() {
        System.err.println("usage: jwarc command [args]\n\nCommands:\n");
        for (Command cmd : Command.values()) {
            System.err.format("    %-10s %s\n", cmd.name(), cmd.help);
        }
    }

    private static enum Command {
        ls("List records in WARC file(s)"){

            @Override
            void exec(String[] args) throws IOException {
                for (String arg : args) {
                    try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                        for (WarcRecord record : reader) {
                            System.out.println(record);
                        }
                    }
                }
            }
        }
        ,
        fetch("Download a URL recording the request and response"){

            @Override
            void exec(String[] args) throws IOException, URISyntaxException {
                try (WarcWriter writer = new WarcWriter(System.out);){
                    for (String arg : args) {
                        writer.fetch(new URI(arg));
                    }
                }
            }
        };

        private final String help;

        private Command(String help) {
            this.help = help;
        }

        abstract void exec(String[] var1) throws Exception;
    }
}

