/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;

public class WarcResponse
extends WarcCaptureRecord {
    private HttpResponse http;

    WarcResponse(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    public HttpResponse http() throws IOException {
        if (this.http == null) {
            this.http = HttpResponse.parse(this.body());
        }
        return this.http;
    }

    @Override
    public Optional<WarcPayload> payload() throws IOException {
        if (this.contentType().base().equals(MediaType.HTTP)) {
            return Optional.of(new WarcPayload(this.http().body()){

                @Override
                MediaType type() {
                    return WarcResponse.this.http.contentType();
                }

                @Override
                Optional<MediaType> identifiedType() {
                    return WarcResponse.this.identifiedPayloadType();
                }

                @Override
                Optional<WarcDigest> digest() {
                    return WarcResponse.this.payloadDigest();
                }
            });
        }
        return Optional.empty();
    }

    public static class Builder
    extends WarcCaptureRecord.AbstractBuilder<WarcResponse, Builder> {
        public Builder(URI targetURI) {
            super("response");
            this.setHeader("WARC-Target-URI", targetURI.toString());
        }

        public Builder body(HttpResponse httpResponse) {
            return (Builder)this.body(MediaType.HTTP_RESPONSE, httpResponse);
        }

        @Override
        public WarcResponse build() {
            return this.build(WarcResponse::new);
        }
    }
}

