/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

class IOUtils {
    IOUtils() {
    }

    static int transfer(ByteBuffer src, ByteBuffer dst) {
        return IOUtils.transferExactly(src, dst, Math.min(dst.remaining(), dst.remaining()));
    }

    static int transfer(ByteBuffer src, ByteBuffer dst, long limit) {
        return IOUtils.transferExactly(src, dst, (int)Math.min((long)Math.min(dst.remaining(), dst.remaining()), limit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int transferExactly(ByteBuffer src, ByteBuffer dst, int n) {
        if (src.remaining() > n) {
            int savedLimit = src.limit();
            try {
                src.limit(src.position() + n);
                dst.put(src);
                int n2 = n;
                return n2;
            }
            finally {
                src.limit(savedLimit);
            }
        }
        dst.put(src);
        return n;
    }

    static ReadableByteChannel prefixChannel(final ByteBuffer prefix, final ReadableByteChannel channel) {
        return new ReadableByteChannel(){

            @Override
            public int read(ByteBuffer byteBuffer) throws IOException {
                int n = 0;
                if (prefix.hasRemaining()) {
                    n += IOUtils.transfer(prefix, byteBuffer);
                }
                if (byteBuffer.hasRemaining()) {
                    n += channel.read(byteBuffer);
                }
                return n;
            }

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }
        };
    }

    static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] buffer = new byte[8192];
        while ((n = inputStream.read(buffer)) >= 0) {
            outputStream.write(buffer, 0, n);
        }
    }
}

