/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.util.Arrays;
import org.netpreserve.jwarc.tools.CdxTool;
import org.netpreserve.jwarc.tools.ExtractTool;
import org.netpreserve.jwarc.tools.FetchTool;
import org.netpreserve.jwarc.tools.FilterTool;
import org.netpreserve.jwarc.tools.ListTool;
import org.netpreserve.jwarc.tools.RecordTool;
import org.netpreserve.jwarc.tools.RecorderTool;
import org.netpreserve.jwarc.tools.SavebackTool;
import org.netpreserve.jwarc.tools.ScreenshotTool;
import org.netpreserve.jwarc.tools.ServeTool;
import org.netpreserve.jwarc.tools.Utils;
import org.netpreserve.jwarc.tools.ValidateTool;

public class WarcTool {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            WarcTool.usage();
            return;
        }
        String[] rest = Arrays.copyOfRange(args, 1, args.length);
        switch (args[0]) {
            case "cdx": {
                CdxTool.main(rest);
                break;
            }
            case "extract": {
                ExtractTool.main(rest);
                break;
            }
            case "fetch": {
                FetchTool.main(rest);
                break;
            }
            case "filter": {
                FilterTool.main(rest);
                break;
            }
            case "-h": 
            case "--help": 
            case "help": {
                WarcTool.usage();
                break;
            }
            case "ls": {
                ListTool.main(rest);
                break;
            }
            case "record": {
                RecordTool.main(rest);
                break;
            }
            case "recorder": {
                RecorderTool.main(rest);
                break;
            }
            case "saveback": {
                SavebackTool.main(rest);
                break;
            }
            case "screenshot": {
                ScreenshotTool.main(rest);
                break;
            }
            case "serve": {
                ServeTool.main(rest);
                break;
            }
            case "validate": {
                ValidateTool.main(rest);
                break;
            }
            case "--version": 
            case "version": {
                WarcTool.version();
                break;
            }
            default: {
                System.err.println("jwarc: '" + args[0] + "' is not a jwarc command. See 'jwarc help'.");
                System.exit(1);
            }
        }
    }

    private static void usage() {
        System.out.println("usage: jwarc <command> [args]...");
        System.out.println();
        System.out.println("Commands:");
        System.out.println();
        System.out.println("  cdx         List records in CDX format");
        System.out.println("  extract     Extract record by offset");
        System.out.println("  fetch       Download a URL recording the request and response");
        System.out.println("  filter      Copy records that match a given filter expression");
        System.out.println("  ls          List records in WARC file(s)");
        System.out.println("  record      Fetch a page and subresources using headless Chrome");
        System.out.println("  recorder    Run a recording proxy");
        System.out.println("  saveback    Saves wayback-style replayed pages as WARC records");
        System.out.println("  screenshot  Take a screenshot of each page in the given WARCs");
        System.out.println("  serve       Serve WARC files with a basic replay server/proxy");
        System.out.println("  validate    Validate WARC or ARC files");
        System.out.println("  version     Print version information");
    }

    private static void version() {
        String version = Utils.getJwarcVersion();
        System.out.println("jwarc " + (version == null ? "unknown version" : version));
        System.out.println(System.getProperty("java.vm.name") + " " + System.getProperty("java.version"));
        System.out.println(System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
    }
}

