/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.netpreserve.jwarc.HttpMessage;
import org.netpreserve.jwarc.HttpRequest;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;
import org.netpreserve.jwarc.WarcTargetRecord;
import org.netpreserve.jwarc.tools.WarcTool;

public class ValidateTool
extends WarcTool {
    private static final MediaType DNS = MediaType.parse("text/dns");
    private Logger logger;
    private boolean verbose;

    public ValidateTool(boolean verbose) {
        this.verbose = verbose;
        this.logger = verbose ? new Logger() : new NonVerboseLogger();
    }

    private static long readBody(MessageBody body, Consumer<ByteBuffer> consumer) throws IOException {
        long size = 0L;
        int i = 0;
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        while ((i = body.read(buffer)) > -1) {
            size += (long)i;
            consumer.accept(buffer);
            buffer.compact();
        }
        return size;
    }

    private static void validateDigest(WarcDigest digestExpected, WarcDigest digestCalculated, long size) throws DigestException {
        if (!digestCalculated.equals(digestCalculated)) {
            throw new DigestException("Failed to validate digest: expected " + digestExpected + ", got " + digestCalculated + " (on " + size + " bytes)");
        }
    }

    private static void validateDigest(MessageBody body, WarcDigest digest, AtomicLong consumedBytes) throws IOException, NoSuchAlgorithmException, DigestException {
        MessageDigest md = digest.getDigester();
        long size = ValidateTool.readBody(body, b -> md.update((ByteBuffer)b));
        consumedBytes.set(size);
        WarcDigest dig = new WarcDigest(md);
        ValidateTool.validateDigest(digest, dig, size);
    }

    private boolean validateCapture(WarcRecord record) throws IOException {
        HttpMessage http;
        boolean valid = true;
        int contentLength = -1;
        String targetUri = ((WarcTargetRecord)record).target();
        this.logger.log(targetUri);
        if (record instanceof WarcResponse && record.contentType().equals(MediaType.HTTP_RESPONSE)) {
            http = ((WarcResponse)record).http();
            this.logger.log("%s %d %s", http.version(), ((HttpResponse)http).status(), ((HttpResponse)http).reason());
            Optional<String> contentLengthHeader = http.headers().first("content-length");
            if (contentLengthHeader.isPresent()) {
                try {
                    contentLength = Integer.parseInt(contentLengthHeader.get());
                }
                catch (NumberFormatException e) {
                    this.logger.error("failed to read HTTP Content-Length header: %s", contentLengthHeader.get());
                    valid = false;
                }
            }
        } else if (record instanceof WarcRequest && record.contentType().equals(MediaType.HTTP_REQUEST)) {
            http = ((WarcRequest)record).http();
            this.logger.log("%s %s", http.version(), ((HttpRequest)http).method());
        } else if (!(record instanceof WarcResponse) || record.contentType().equals(DNS)) {
            // empty if block
        }
        this.logger.log("date: %s", record.date());
        Optional<WarcPayload> payload = ((WarcCaptureRecord)record).payload();
        if (payload.isPresent()) {
            MediaType type;
            try {
                type = payload.get().type().base();
                this.logger.log("payload media type: %s", type);
            }
            catch (IllegalArgumentException e) {
                this.logger.exception("Parsing Content-Type failed", e);
                type = MediaType.OCTET_STREAM;
            }
            Optional<WarcDigest> pdigest = payload.get().digest();
            long length = -1L;
            if (pdigest.isPresent()) {
                AtomicLong plength = new AtomicLong(length);
                try {
                    ValidateTool.validateDigest(payload.get().body(), pdigest.get(), plength);
                    this.logger.log("payload digest pass");
                }
                catch (DigestException e) {
                    this.logger.error("payload digest failed: %s", e.getMessage());
                    valid = false;
                }
                catch (NoSuchAlgorithmException e) {
                    this.logger.log("payload digest unknown algorithm: %s", e.getMessage());
                }
                length = plength.get();
            } else {
                length = ValidateTool.readBody(payload.get().body(), b -> b.rewind());
            }
            if (contentLength > 0 && (long)contentLength != length) {
                this.logger.error("invalid HTTP header Content-Length: %d", contentLength);
                valid = false;
            }
        }
        return valid;
    }

    private boolean validate(WarcReader reader) throws IOException {
        boolean warcValidates = true;
        AtomicBoolean sawWarning = new AtomicBoolean(false);
        reader.onWarning(message -> {
            this.logger.error((String)message, new Object[0]);
            sawWarning.set(true);
        });
        WarcRecord record = reader.next().orElse(null);
        while (record != null) {
            boolean valid = true;
            if (record instanceof WarcCaptureRecord) {
                try {
                    valid = this.validateCapture(record);
                }
                catch (IOException e) {
                    this.logger.exception("Exception during validation", e);
                    valid = false;
                }
            } else {
                record.body().consume();
            }
            if (record.blockDigest().isPresent()) {
                Optional<WarcDigest> calculated = record.calculatedBlockDigest();
                if (calculated.isPresent()) {
                    try {
                        ValidateTool.validateDigest(record.blockDigest().get(), calculated.get(), record.body().position());
                        this.logger.log("block digest pass");
                    }
                    catch (DigestException e) {
                        this.logger.error("block digest failed: %s", e.getMessage());
                        valid = false;
                    }
                } else {
                    try {
                        record.blockDigest().get().getDigester();
                        this.logger.log("block digest not calculated (unknown reason)");
                    }
                    catch (NoSuchAlgorithmException e) {
                        this.logger.log("block digest not calculated: %s", e.getMessage());
                    }
                }
            }
            String recordType = record.type();
            MediaType contentType = record.contentType();
            long position = reader.position();
            if (sawWarning.getAndSet(false)) {
                valid = false;
            }
            record = reader.next().orElse(null);
            long length = reader.position() - position;
            if (this.verbose) {
                System.out.printf("  offset %d (length %d) %s %s\n%s", position, length, recordType, contentType, this.logger.print());
            } else if (!valid) {
                System.err.printf("  offset %d (length %d) %s %s failed\n", position, length, recordType, contentType);
            }
            if (valid) continue;
            warcValidates = false;
        }
        if (sawWarning.get()) {
            warcValidates = false;
        }
        return warcValidates;
    }

    private static void usage(int exitValue) {
        System.err.println("");
        System.err.println("ValidateTool [-h] [-v] filename...");
        System.err.println("");
        System.err.println("Options:");
        System.err.println("");
        System.err.println(" -h / --help\tshow usage message and exit");
        System.err.println(" -v / --verbose\tlog information about every WARC record to stdout");
        System.err.println("");
        System.err.println("Exit value is 0 if all WARC/ARC files validate, 1 otherwise.");
        System.err.println("Errors and erroneous WARC/ARC records are logged to stderr.");
        System.err.println("");
        System.exit(exitValue);
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws IOException {
        res = 0;
        verbose = false;
        if (args.length == 0) {
            ValidateTool.usage(0);
        }
        var3_3 = args;
        var4_4 = var3_3.length;
        block18: for (var5_5 = 0; var5_5 < var4_4; ++var5_5) {
            var7_7 = arg = var3_3[var5_5];
            var8_8 = -1;
            switch (var7_7.hashCode()) {
                case 1499: {
                    if (!var7_7.equals("-h")) break;
                    var8_8 = 0;
                    break;
                }
                case 1333069025: {
                    if (!var7_7.equals("--help")) break;
                    var8_8 = 1;
                    break;
                }
                case 1513: {
                    if (!var7_7.equals("-v")) break;
                    var8_8 = 2;
                    break;
                }
                case 1737088994: {
                    if (!var7_7.equals("--verbose")) break;
                    var8_8 = 3;
                }
            }
            switch (var8_8) {
                case 0: 
                case 1: {
                    ValidateTool.usage(0);
                    continue block18;
                }
                case 2: 
                case 3: {
                    verbose = true;
                    continue block18;
                }
                default: {
                    validator = new ValidateTool(verbose);
                    reader = new WarcReader(Paths.get(arg, new String[0]));
                    var11_11 = null;
                    reader.calculateBlockDigest();
                    if (verbose) {
                        System.out.println("Validating " + arg);
                    }
                    if (!validator.validate(reader)) {
                        System.err.println("Failed to validate " + arg);
                        res = 1;
                    }
                    if (reader == null) continue block18;
                    if (var11_11 == null) ** GOTO lbl52
                    try {
                        reader.close();
                    }
                    catch (Throwable var12_12) {
                        var11_11.addSuppressed(var12_12);
                    }
                    continue block18;
lbl52:
                    // 1 sources

                    reader.close();
                    continue block18;
                    catch (Throwable var12_13) {
                        try {
                            var11_11 = var12_13;
                            throw var12_13;
                        }
                        catch (Throwable var13_14) {
                            if (reader != null) {
                                if (var11_11 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable var14_15) {
                                        var11_11.addSuppressed(var14_15);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                            throw var13_14;
                        }
                    }
                }
            }
        }
        System.exit(res);
    }

    private static class NonVerboseLogger
    extends Logger {
        public NonVerboseLogger() {
            this.sb = Optional.empty();
        }
    }

    private static class Logger {
        protected Optional<StringBuilder> sb = Optional.of(new StringBuilder());

        public void log(String form) {
            this.sb.ifPresent(s -> s.append("    ").append(form).append('\n'));
        }

        public void log(String form, Object ... args) {
            this.sb.ifPresent(s -> s.append("    ").append(String.format(form, args)).append('\n'));
        }

        public void error(String form, Object ... args) {
            if (this.sb.isPresent()) {
                this.log("ERROR: " + form, args);
            } else {
                System.err.println("ERROR: " + String.format(form, args));
            }
        }

        public void exception(String message, Exception e) {
            if (this.sb.isPresent()) {
                this.log("ERROR: %s: %s", message, e);
            } else {
                System.err.println("ERROR: " + message + ": " + e);
            }
        }

        public String print() {
            String res = "";
            if (this.sb.isPresent()) {
                res = this.sb.get().toString();
                this.sb.get().setLength(0);
            }
            return res;
        }
    }
}

