/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.tools;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.ParsingException;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcResource;
import org.netpreserve.jwarc.WarcResponse;

public class CdxTool {
    public static void main(String[] args) throws IOException {
        DateTimeFormatter arcDate = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
        for (String arg : args) {
            try (WarcReader reader = new WarcReader(Paths.get(arg, new String[0]));){
                reader.onWarning(System.err::println);
                WarcRecord record = reader.next().orElse(null);
                while (record != null) {
                    try {
                        if ((record instanceof WarcResponse || record instanceof WarcResource) && ((WarcCaptureRecord)record).payload().isPresent()) {
                            MediaType type;
                            WarcPayload payload = ((WarcCaptureRecord)record).payload().get();
                            try {
                                type = payload.type().base();
                            }
                            catch (IllegalArgumentException e) {
                                type = MediaType.OCTET_STREAM;
                            }
                            URI uri = ((WarcCaptureRecord)record).targetURI();
                            String date = arcDate.format(record.date());
                            int status = record instanceof WarcResponse ? ((WarcResponse)record).http().status() : 200;
                            String digest = payload.digest().map(WarcDigest::base32).orElse("-");
                            long position = reader.position();
                            record = reader.next().orElse(null);
                            long length = reader.position() - position;
                            System.out.printf("%s %s %s %s %d %s - - %d %d %s%n", uri, date, uri, type, status, digest, length, position, arg);
                            continue;
                        }
                        record = reader.next().orElse(null);
                    }
                    catch (ParsingException e) {
                        System.err.println("ParsingException at record " + reader.position() + ": " + e.getMessage());
                        record = reader.next().orElse(null);
                    }
                }
            }
        }
    }
}

