/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.security.MessageDigest;
import java.util.Locale;
import java.util.Objects;

public class WarcDigest {
    private final String algorithm;
    private final String value;

    public WarcDigest(String digest) {
        int i = digest.indexOf(58);
        if (i == -1) {
            throw new IllegalArgumentException("Invalid WARC-Digest");
        }
        this.algorithm = digest.substring(0, i);
        this.value = digest.substring(i + 1);
    }

    public WarcDigest(String algorithm, String value) {
        this.algorithm = algorithm;
        this.value = value;
    }

    public WarcDigest(String algorithm, byte[] value) {
        this(algorithm, WarcDigest.base32Encode(value));
    }

    public WarcDigest(MessageDigest messageDigest) {
        this.algorithm = messageDigest.getAlgorithm().replace("-", "").toLowerCase(Locale.US);
        this.value = WarcDigest.base32Encode(messageDigest.digest());
    }

    public String algorithm() {
        return this.algorithm;
    }

    public String base32() {
        return this.value;
    }

    public String hex() {
        return WarcDigest.hexEncode(this.bytes());
    }

    public byte[] bytes() {
        return WarcDigest.base32Decode(this.value);
    }

    public String toString() {
        return this.prefixedBase32();
    }

    public String prefixedBase32() {
        return this.algorithm + ":" + this.value;
    }

    static String hexEncode(byte[] data) {
        StringBuilder out = new StringBuilder(data.length * 2);
        for (byte b : data) {
            out.append("0123456789abcdef".charAt((b & 0xF0) >>> 4));
            out.append("0123456789abcdef".charAt(b & 0xF));
        }
        return out.toString();
    }

    static String base32Encode(byte[] data) {
        StringBuilder out = new StringBuilder(data.length / 5 * 8);
        int i = 0;
        while (i < data.length) {
            int j;
            long bits = 0L;
            for (j = 0; j < 5; ++j) {
                bits = bits << 8 | (long)(data[i++] & 0xFF);
            }
            for (j = 0; j < 8; ++j) {
                out.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt((int)(bits >> 5 * (7 - j)) & 0x1F));
            }
        }
        return out.toString();
    }

    static byte[] base32Decode(String data) {
        byte[] out = new byte[data.length() / 8 * 5];
        int i = 0;
        int k = 0;
        while (k < out.length) {
            int j;
            long bits = 0L;
            for (j = 0; j < 8; ++j) {
                int value;
                int c;
                if ((c = data.charAt(i++) | 0x20) >= 97 && c <= 122) {
                    value = c - 97;
                } else if (c >= 50 && c <= 55) {
                    value = c - 50 + 26;
                } else {
                    throw new IllegalArgumentException("Invalid base32 character: " + c);
                }
                bits = bits << 5 | (long)value;
            }
            for (j = 0; j < 5; ++j) {
                out[k++] = (byte)(bits >> 8 * (4 - j) & 0xFFL);
            }
        }
        return out;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarcDigest digest = (WarcDigest)o;
        return Objects.equals(this.algorithm, digest.algorithm) && Objects.equals(this.value, digest.value);
    }

    public int hashCode() {
        return Objects.hash(this.algorithm, this.value);
    }
}

