/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.EOFException;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageParser;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.ParsingException;

public class HttpParser
extends MessageParser {
    private int initialState;
    private int cs;
    private long position;
    private boolean finished;
    private byte[] buf = new byte[256];
    private int bufPos = 0;
    private int endOfText;
    private int major;
    private int minor;
    private int status;
    private String reason;
    private String method;
    private String target;
    private String name;
    private Map<String, List<String>> headerMap;
    private static final byte[] _http_actions = HttpParser.init__http_actions_0();
    private static final short[] _http_key_offsets = HttpParser.init__http_key_offsets_0();
    private static final char[] _http_trans_keys = HttpParser.init__http_trans_keys_0();
    private static final byte[] _http_single_lengths = HttpParser.init__http_single_lengths_0();
    private static final byte[] _http_range_lengths = HttpParser.init__http_range_lengths_0();
    private static final short[] _http_index_offsets = HttpParser.init__http_index_offsets_0();
    private static final byte[] _http_trans_targs = HttpParser.init__http_trans_targs_0();
    private static final byte[] _http_trans_actions = HttpParser.init__http_trans_actions_0();
    static final int http_start = 1;
    static final int http_first_final = 101;
    static final int http_error = 0;
    static final int http_en_http_request = 28;
    static final int http_en_http_response = 51;
    static final int http_en_http_request_lenient = 75;
    static final int http_en_http_response_lenient = 1;

    public HttpParser() {
        this.reset();
    }

    public void reset() {
        this.cs = 1;
        this.bufPos = 0;
        if (this.buf.length > 8192) {
            this.buf = new byte[256];
        }
        this.major = 0;
        this.minor = 0;
        this.status = 0;
        this.reason = null;
        this.method = null;
        this.target = null;
        this.name = null;
        this.headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        this.endOfText = 0;
        this.position = 0L;
        this.finished = false;
        this.cs = this.initialState;
    }

    public MessageHeaders headers() {
        return new MessageHeaders(this.headerMap);
    }

    public MessageVersion version() {
        return new MessageVersion("HTTP", this.major, this.minor);
    }

    public int status() {
        return this.status;
    }

    public String reason() {
        return this.reason;
    }

    public String target() {
        return this.target;
    }

    public String method() {
        return this.method;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isError() {
        return this.cs == 0;
    }

    public void strictRequest() {
        this.initialState = this.cs = 28;
    }

    public void strictResponse() {
        this.initialState = this.cs = 51;
    }

    public void lenientRequest() {
        this.initialState = this.cs = 75;
    }

    public void lenientResponse() {
        this.initialState = this.cs = 1;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(ByteBuffer data) {
        p = data.position();
        pe = data.limit();
        _trans = 0;
        _goto_targ = 0;
        block19: while (true) {
            switch (_goto_targ) {
                case 0: {
                    if (p == pe) {
                        _goto_targ = 4;
                        continue block19;
                    }
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block19;
                    }
                }
                case 1: {
                    _keys = HttpParser._http_key_offsets[this.cs];
                    _trans = HttpParser._http_index_offsets[this.cs];
                    _klen = HttpParser._http_single_lengths[this.cs];
                    if (_klen <= 0) ** GOTO lbl33
                    _lower = _keys;
                    _upper = _keys + _klen - 1;
                    while (_upper >= _lower) {
                        _mid = _lower + (_upper - _lower >> 1);
                        if ((data.get(p) & 255) < HttpParser._http_trans_keys[_mid]) {
                            _upper = _mid - 1;
                            continue;
                        }
                        if ((data.get(p) & 255) > HttpParser._http_trans_keys[_mid]) {
                            _lower = _mid + 1;
                            continue;
                        }
                        _trans += _mid - _keys;
                        ** GOTO lbl47
                    }
                    _keys += _klen;
                    _trans += _klen;
lbl33:
                    // 2 sources

                    if ((_klen = HttpParser._http_range_lengths[this.cs]) > 0) {
                        _lower = _keys;
                        _upper = _keys + (_klen << 1) - 2;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1 & -2);
                            if ((data.get(p) & 255) < HttpParser._http_trans_keys[_mid]) {
                                _upper = _mid - 2;
                                continue;
                            }
                            if ((data.get(p) & 255) > HttpParser._http_trans_keys[_mid + 1]) {
                                _lower = _mid + 2;
                                continue;
                            }
                            _trans += _mid - _keys >> 1;
                            ** GOTO lbl47
                        }
                        _trans += _klen;
                    }
lbl47:
                    // 5 sources

                    this.cs = HttpParser._http_trans_targs[_trans];
                    if (HttpParser._http_trans_actions[_trans] != 0) {
                        _acts = HttpParser._http_trans_actions[_trans];
                        _nacts = HttpParser._http_actions[_acts++];
                        while (_nacts-- > 0) {
                            switch (HttpParser._http_actions[_acts++]) {
                                case 0: {
                                    this.push(data.get(p));
                                    break;
                                }
                                case 1: {
                                    this.major = this.major * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 2: {
                                    this.minor = this.minor * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 3: {
                                    this.status = this.status * 10 + data.get(p) - 48;
                                    break;
                                }
                                case 4: {
                                    this.endOfText = this.bufPos;
                                    break;
                                }
                                case 5: {
                                    this.method = new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 6: {
                                    this.reason = new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 7: {
                                    this.target = new String(this.buf, 0, this.bufPos, StandardCharsets.ISO_8859_1);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 8: {
                                    this.finished = true;
                                    break;
                                }
                                case 9: {
                                    if (this.bufPos <= 0) break;
                                    this.bufPos = this.endOfText;
                                    this.push((byte)32);
                                    break;
                                }
                                case 10: {
                                    this.name = new String(this.buf, 0, this.bufPos, StandardCharsets.US_ASCII);
                                    this.bufPos = 0;
                                    break;
                                }
                                case 11: {
                                    value = new String(this.buf, 0, this.endOfText, StandardCharsets.ISO_8859_1);
                                    this.headerMap.computeIfAbsent(this.name, (Function<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$parse$0(java.lang.String ), (Ljava/lang/String;)Ljava/util/List;)()).add(value);
                                    this.bufPos = 0;
                                    this.endOfText = 0;
                                }
                            }
                        }
                    }
                }
                case 2: {
                    if (this.cs == 0) {
                        _goto_targ = 5;
                        continue block19;
                    }
                    if (++p == pe) break block19;
                    _goto_targ = 1;
                    continue block19;
                }
            }
            break;
        }
        this.position += (long)(p - data.position());
        data.position(p);
    }

    public void parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        this.parse(channel, buffer, null);
    }

    void parse(ReadableByteChannel channel, ByteBuffer buffer, WritableByteChannel copyTo) throws IOException {
        while (true) {
            ByteBuffer copy = buffer.duplicate();
            long buffOffset = (long)buffer.position() - this.position;
            this.parse(buffer);
            if (copyTo != null) {
                copy.limit(buffer.position());
                copyTo.write(copy);
            }
            if (this.isFinished()) break;
            if (this.isError()) {
                throw new ParsingException("invalid HTTP message at byte position " + this.position + ": " + HttpParser.getErrorContext(buffer.duplicate(), (int)(buffOffset + this.position), 40));
            }
            buffer.compact();
            int n = channel.read(buffer);
            if (n < 0) {
                throw new EOFException("state=" + this.cs);
            }
            buffer.flip();
        }
    }

    private void push(byte b) {
        if (this.bufPos >= this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
        }
        this.buf[this.bufPos++] = b;
    }

    private static byte[] init__http_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 11, 2, 4, 0, 2, 9, 0, 2, 11, 0, 2, 11, 8};
    }

    private static short[] init__http_key_offsets_0() {
        return new short[]{0, 0, 1, 2, 3, 4, 5, 7, 8, 10, 11, 14, 16, 18, 21, 38, 39, 57, 60, 64, 68, 72, 89, 93, 97, 116, 120, 121, 128, 143, 159, 171, 184, 185, 186, 187, 188, 189, 191, 192, 194, 195, 196, 212, 213, 229, 236, 237, 255, 262, 269, 276, 277, 278, 279, 280, 281, 283, 284, 286, 287, 289, 291, 293, 294, 300, 301, 317, 318, 334, 341, 342, 360, 367, 374, 381, 396, 412, 414, 416, 418, 419, 420, 421, 422, 424, 425, 427, 430, 447, 448, 466, 469, 473, 477, 481, 498, 502, 506, 525, 529, 530, 530, 530, 530};
    }

    private static char[] init__http_trans_keys_0() {
        return new char[]{'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', ' ', ' ', '0', '9', '0', '9', '0', '9', '\n', '\r', ' ', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '\t', ' ', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ':', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\n', '\r', ' ', '\n', '\t', '\n', '\r', ' ', '~', '\u0080', '\u00ff', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '!', '=', '_', '~', '$', ';', '?', 'Z', 'a', 'z', '\u0080', '\u00ff', ' ', '!', '=', '_', '~', '$', ';', '?', 'Z', 'a', 'z', '\u0080', '\u00ff', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', '\r', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', ' ', '0', '9', '0', '9', '0', '9', ' ', '\t', '\r', ' ', '~', '\u0080', '\u00ff', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\n', '\t', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '\t', '\r', ' ', '!', '~', '\u0080', '\u00ff', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', ' ', '\n', ' ', ' ', 'H', 'T', 'T', 'P', '/', '0', '9', '.', '0', '9', '\n', '\r', ' ', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\n', '\t', ' ', '!', ':', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', ' ', ':', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\n', '\r', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '\t', '\n', '\r', ' ', '!', '|', '~', '#', '\'', '*', '+', '-', '.', '0', '9', 'A', 'Z', '^', 'z', '\t', '\n', '\r', ' ', '\n', '\u0000'};
    }

    private static byte[] init__http_single_lengths_0() {
        return new byte[]{0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 3, 5, 1, 6, 3, 4, 4, 4, 5, 4, 4, 7, 4, 1, 3, 3, 4, 4, 5, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 4, 1, 4, 3, 1, 6, 3, 3, 3, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 2, 1, 4, 1, 4, 3, 1, 6, 3, 3, 3, 3, 4, 2, 2, 2, 1, 1, 1, 1, 0, 1, 0, 3, 5, 1, 6, 3, 4, 4, 4, 5, 4, 4, 7, 4, 1, 0, 0, 0, 0};
    }

    private static byte[] init__http_range_lengths_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 6, 0, 6, 0, 0, 0, 0, 6, 0, 0, 6, 0, 0, 2, 6, 6, 4, 4, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 6, 0, 6, 2, 0, 6, 2, 2, 2, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 2, 0, 6, 0, 6, 2, 0, 6, 2, 2, 2, 6, 6, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 6, 0, 6, 0, 0, 0, 0, 6, 0, 0, 6, 0, 0, 0, 0, 0, 0};
    }

    private static short[] init__http_index_offsets_0() {
        return new short[]{0, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 21, 23, 25, 29, 41, 43, 56, 60, 65, 70, 75, 87, 92, 97, 111, 116, 118, 124, 134, 145, 154, 164, 166, 168, 170, 172, 174, 176, 178, 180, 182, 184, 195, 197, 208, 214, 216, 229, 235, 241, 247, 249, 251, 253, 255, 257, 259, 261, 263, 265, 267, 269, 271, 273, 278, 280, 291, 293, 304, 310, 312, 325, 331, 337, 343, 353, 364, 367, 370, 373, 375, 377, 379, 381, 383, 385, 387, 391, 403, 405, 418, 422, 427, 432, 437, 449, 454, 459, 473, 478, 480, 481, 482, 483};
    }

    private static byte[] init__http_trans_targs_0() {
        return new byte[]{2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8, 0, 9, 0, 10, 0, 10, 11, 0, 12, 0, 13, 0, 14, 26, 27, 0, 101, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 101, 0, 17, 17, 16, 18, 16, 16, 16, 16, 16, 16, 16, 16, 0, 17, 17, 18, 0, 18, 21, 22, 18, 19, 20, 21, 22, 20, 19, 20, 21, 22, 20, 19, 101, 15, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 23, 24, 23, 23, 19, 23, 0, 23, 23, 19, 25, 101, 15, 25, 16, 16, 16, 16, 16, 16, 16, 16, 16, 0, 25, 21, 22, 25, 19, 14, 0, 27, 14, 26, 27, 27, 0, 29, 29, 29, 29, 29, 29, 29, 29, 29, 0, 30, 29, 29, 29, 29, 29, 29, 29, 29, 29, 0, 31, 31, 31, 31, 31, 31, 31, 31, 0, 32, 31, 31, 31, 31, 31, 31, 31, 31, 0, 33, 0, 34, 0, 35, 0, 36, 0, 37, 0, 38, 0, 39, 0, 40, 0, 41, 0, 42, 0, 43, 44, 44, 44, 44, 44, 44, 44, 44, 44, 0, 102, 0, 44, 45, 44, 44, 44, 44, 44, 44, 44, 44, 0, 45, 46, 45, 49, 49, 0, 47, 0, 48, 43, 48, 44, 44, 44, 44, 44, 44, 44, 44, 44, 0, 48, 46, 48, 49, 49, 0, 50, 46, 50, 49, 49, 0, 50, 46, 50, 49, 49, 0, 52, 0, 53, 0, 54, 0, 55, 0, 56, 0, 57, 0, 58, 0, 59, 0, 60, 0, 61, 0, 62, 0, 63, 0, 64, 0, 64, 65, 64, 64, 0, 66, 0, 67, 68, 68, 68, 68, 68, 68, 68, 68, 68, 0, 103, 0, 68, 69, 68, 68, 68, 68, 68, 68, 68, 68, 0, 69, 70, 69, 73, 73, 0, 71, 0, 72, 67, 72, 68, 68, 68, 68, 68, 68, 68, 68, 68, 0, 72, 70, 72, 73, 73, 0, 74, 70, 74, 73, 73, 0, 74, 70, 74, 73, 73, 0, 76, 76, 76, 76, 76, 76, 76, 76, 76, 0, 77, 76, 76, 76, 76, 76, 76, 76, 76, 76, 0, 0, 77, 78, 0, 79, 78, 79, 80, 0, 81, 0, 82, 0, 83, 0, 84, 0, 85, 0, 86, 0, 87, 0, 88, 100, 87, 0, 104, 89, 90, 90, 90, 90, 90, 90, 90, 90, 90, 0, 104, 0, 91, 91, 90, 92, 90, 90, 90, 90, 90, 90, 90, 90, 0, 91, 91, 92, 0, 92, 95, 96, 92, 93, 94, 95, 96, 94, 93, 94, 95, 96, 94, 93, 104, 89, 90, 90, 90, 90, 90, 90, 90, 90, 90, 0, 97, 98, 97, 97, 93, 97, 0, 97, 97, 93, 99, 104, 89, 99, 90, 90, 90, 90, 90, 90, 90, 90, 90, 0, 99, 95, 96, 99, 93, 88, 0, 0, 0, 0, 0, 0};
    }

    private static byte[] init__http_trans_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 5, 0, 0, 0, 0, 7, 0, 7, 0, 7, 0, 0, 0, 0, 0, 17, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 17, 0, 21, 21, 1, 21, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 25, 9, 25, 25, 1, 1, 0, 1, 1, 1, 34, 23, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 34, 23, 0, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 0, 19, 28, 0, 28, 0, 0, 1, 13, 13, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 15, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 17, 0, 1, 21, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 23, 0, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 0, 19, 0, 28, 28, 0, 25, 9, 25, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 5, 0, 0, 0, 7, 0, 7, 0, 7, 0, 0, 0, 1, 13, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 17, 0, 1, 21, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 23, 0, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 0, 19, 0, 28, 28, 0, 25, 9, 25, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 11, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 15, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 5, 0, 0, 0, 0, 0, 17, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 17, 0, 21, 21, 1, 21, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 25, 9, 25, 25, 1, 1, 0, 1, 1, 1, 34, 23, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 34, 23, 0, 31, 31, 31, 31, 31, 31, 31, 31, 31, 0, 0, 19, 28, 0, 28, 0, 0, 0, 0, 0, 0, 0};
    }

    private static /* synthetic */ List lambda$parse$0(String n) {
        return new ArrayList();
    }
}

