/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.svg;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.XMLResourceDescriptor;
import org.openide.util.CachedHiDPIIcon;
import org.openide.util.Parameters;
import org.w3c.dom.Document;

final class SVGIcon
extends CachedHiDPIIcon {
    private static final Logger LOG = Logger.getLogger(SVGIcon.class.getName());
    private static final int MAX_DIMENSION_PIXELS = 8192;
    private static final ThreadLocal<SAXSVGDocumentFactory> DOCUMENT_FACTORY = new ThreadLocal<SAXSVGDocumentFactory>(){

        @Override
        protected SAXSVGDocumentFactory initialValue() {
            return new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
        }
    };
    private final URL url;
    private WeakReference<GraphicsNode> graphicsNodeWeakRef;
    private GraphicsNode graphicsNodeStrongRef;

    private SVGIcon(URL url, GraphicsNode initialGraphicsNode, int width, int height) {
        super(width, height);
        Parameters.notNull((CharSequence)"url", (Object)url);
        Parameters.notNull((CharSequence)"initialGraphicsNode", (Object)initialGraphicsNode);
        this.url = url;
        this.graphicsNodeStrongRef = initialGraphicsNode;
        this.graphicsNodeWeakRef = new WeakReference<GraphicsNode>(initialGraphicsNode);
    }

    public static Icon load(URL url) throws IOException {
        Parameters.notNull((CharSequence)"url", (Object)url);
        Dimension size = new Dimension();
        GraphicsNode initialGraphicsNode = SVGIcon.loadGraphicsNode(url, size);
        return new SVGIcon(url, initialGraphicsNode, size.width, size.height);
    }

    private synchronized GraphicsNode getGraphicsNode() throws IOException {
        GraphicsNode ret = (GraphicsNode)this.graphicsNodeWeakRef.get();
        if (ret != null) {
            this.graphicsNodeStrongRef = null;
            return ret;
        }
        ret = SVGIcon.loadGraphicsNode(this.url, null);
        this.graphicsNodeWeakRef = new WeakReference<GraphicsNode>(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static GraphicsNode loadGraphicsNode(URL url, Dimension toSize) throws IOException {
        Dimension2D documentSize;
        GraphicsNode graphicsNode;
        Parameters.notNull((CharSequence)"url", (Object)url);
        try (InputStream is = url.openStream();){
            SAXSVGDocumentFactory factory = DOCUMENT_FACTORY.get();
            Document doc = factory.createDocument(null, is);
            UserAgentAdapter userAgent = new UserAgentAdapter();
            DocumentLoader loader = new DocumentLoader((UserAgent)userAgent);
            BridgeContext bctx = new BridgeContext((UserAgent)userAgent, loader);
            try {
                bctx.setDynamicState(0);
                graphicsNode = new GVTBuilder().build(bctx, doc);
                documentSize = bctx.getDocumentSize();
            }
            finally {
                bctx.dispose();
            }
        }
        if (toSize != null) {
            int width = (int)Math.ceil(documentSize.getWidth());
            int height = (int)Math.ceil(documentSize.getHeight());
            int widthLimited = Math.min(8192, width);
            int heightLimited = Math.min(8192, height);
            if (width != widthLimited || height != heightLimited) {
                LOG.log(Level.WARNING, "SVG image {0} too large (dimensions were {1}x{2}, each side can be at most {3}px)", new Object[]{url, width, height, 8192});
            } else if (width <= 1 && height <= 1) {
                LOG.log(Level.WARNING, "SVG image {0} did not specify a width/height, or is incorrectly sized", url);
            }
            toSize.width = widthLimited;
            toSize.height = heightLimited;
        }
        return graphicsNode;
    }

    private static RenderingHints createHints() {
        LinkedHashMap<RenderingHints.Key, Object> hints = new LinkedHashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        hints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        return new RenderingHints(hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image createAndPaintImage(Component c, ColorModel colorModel, int deviceWidth, int deviceHeight, double scale) {
        BufferedImage img = SVGIcon.createBufferedImage((ColorModel)colorModel, (int)deviceWidth, (int)deviceHeight);
        Graphics2D g = GraphicsUtil.createGraphics((BufferedImage)img);
        try {
            g.scale(scale, scale);
            try {
                GraphicsNode graphicsNode = this.getGraphicsNode();
                g.addRenderingHints(SVGIcon.createHints());
                graphicsNode.paint(g);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unexpected exception while re-loading an SVG file that previously loaded successfully", e);
            }
        }
        finally {
            g.dispose();
        }
        return img;
    }
}

