/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.XMLProcessorDetail;
import org.netbeans.modules.xml.util.Util;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

@Deprecated
public final class InputOutputReporter
implements CookieObserver {
    private final String FORMAT = "{0} [{1}] {2}";
    private String ioName;
    private DataObject dataObject;
    private static final Set hyperlinks = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    public InputOutputReporter() {
        this(Util.THIS.getString(InputOutputReporter.class, "TITLE_XML_check_window"));
    }

    public InputOutputReporter(String name) {
        this.initInputOutput(name);
    }

    public void setNode(Node node) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("InputOutputReporter.setNode: " + node, new RuntimeException("Who calls InputOutputReporter.setNode"));
        }
        this.dataObject = (DataObject)node.getCookie(DataObject.class);
    }

    private DataObject dataObject() {
        return this.dataObject;
    }

    public void receive(CookieMessage msg) {
        Object detail = msg.getDetail(XMLProcessorDetail.class);
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("InputOutputReporter.receive:");
            Util.THIS.debug("    dataObject = " + this.dataObject);
            Util.THIS.debug("    Message = " + msg);
            Util.THIS.debug("    detail  = " + detail);
            if (detail == null) {
                Util.THIS.debug(new RuntimeException("Message's Detail is _null_!!!"));
            }
        }
        if (detail instanceof XMLProcessorDetail) {
            this.display(this.dataObject(), msg.getMessage(), (XMLProcessorDetail)detail);
        } else {
            this.message(msg.getMessage());
        }
    }

    public void message(String message) {
        this.out().println(message);
    }

    public final void moveToFront() {
        this.moveToFront(false);
    }

    public final void moveToFront(boolean lastMessage) {
        boolean wasFocusTaken = this.tab().isFocusTaken();
        this.tab().select();
        this.tab().setFocusTaken(true);
        this.out().write("\r");
        this.tab().setFocusTaken(wasFocusTaken);
        if (lastMessage) {
            this.out().close();
        }
    }

    private void display(DataObject dobj, String message, XMLProcessorDetail detail) {
        DataObject actualDataObject;
        block7: {
            actualDataObject = null;
            try {
                String systemId = detail.getSystemId();
                URL url = new URL(systemId);
                FileObject fos = URLMapper.findFileObject((URL)url);
                if (fos != null) {
                    actualDataObject = DataObject.find((FileObject)fos);
                }
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("InputOutputReporter.display: " + message);
                    Util.THIS.debug("    systemId = " + detail.getSystemId());
                    Util.THIS.debug("    url = " + url);
                    Util.THIS.debug("    fos = " + fos);
                }
            }
            catch (MalformedURLException ex) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug(ex);
                }
            }
            catch (DataObjectNotFoundException ex) {
                if (!Util.THIS.isLoggable()) break block7;
                Util.THIS.debug(ex);
            }
        }
        String external = "";
        if (actualDataObject == null) {
            external = detail.getSystemId();
        }
        this.display(actualDataObject, message, external, detail.getLineNumber(), detail.getColumnNumber());
    }

    private void display(DataObject dobj, String message, String ext, int line, int col) {
        String text = null;
        if (line >= 0) {
            Object[] args = new Object[]{message, line, ext};
            text = MessageFormat.format("{0} [{1}] {2}", args);
        } else {
            text = message;
        }
        if (dobj == null) {
            this.out().println(text);
        } else {
            try {
                Hyperlink ec = new Hyperlink(text, dobj, Math.max(line - 1, 0), Math.max(col - 1, 0));
                this.out().println(text, (OutputListener)ec);
            }
            catch (IOException catchIt) {
                this.out().println(text);
            }
        }
    }

    private void initInputOutput(String name) {
        this.ioName = name;
        this.tab().setFocusTaken(false);
        try {
            this.out().reset();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private OutputWriter out() {
        return this.tab().getOut();
    }

    private InputOutput tab() {
        return IOProvider.getDefault().getIO(this.ioName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator it = hyperlinks.iterator();
            while (it.hasNext()) {
                ((Hyperlink)it.next()).detach();
            }
            hyperlinks.clear();
        }
    }

    private static class Hyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private Line xline;
        private int column;
        private final String message;

        public Hyperlink(String message, DataObject data, int line, int column) throws IOException {
            this.column = column;
            this.message = message;
            LineCookie cookie = (LineCookie)data.getCookie(LineCookie.class);
            if (cookie == null) {
                throw new FileNotFoundException();
            }
            this.xline = cookie.getLineSet().getCurrent(line);
        }

        public void outputLineSelected(OutputEvent ev) {
            try {
                this.markError();
                this.show(0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineAction(OutputEvent ev) {
            try {
                this.markError();
                this.show(2);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void outputLineCleared(OutputEvent ev) {
            hyperlinks.remove(this);
            this.detach();
        }

        protected void notifyDetached(Annotatable ann) {
            ann.removePropertyChangeListener((PropertyChangeListener)this);
        }

        protected void notifyAttached(Annotatable ann) {
            ann.addPropertyChangeListener((PropertyChangeListener)this);
        }

        private Annotatable createAnnotatable() {
            return this.xline;
        }

        private void show(int mode) {
            if (this.column == -1) {
                this.xline.show(mode);
            } else {
                this.xline.show(mode, this.column);
            }
        }

        private void markError() {
            InputOutputReporter.releaseAllAnnotations();
            hyperlinks.add(this);
            this.attach(this.createAnnotatable());
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-xml-error";
        }

        public String getShortDescription() {
            return this.message;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String prop = ev.getPropertyName();
            if (prop == null || prop.equals("text") || prop.equals("deleted")) {
                this.column = -1;
                hyperlinks.remove(this);
                this.detach();
            }
        }
    }
}

