/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax;

import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ToggleBlockCommentAction;
import org.netbeans.modules.csl.spi.CommentHandler;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.xml.text.XmlCommentHandler;
import org.netbeans.modules.xml.text.completion.NodeSelector;
import org.netbeans.modules.xml.text.syntax.bridge.LegacySyntaxBridge;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class XMLKit
extends NbEditorKit
implements HelpCtx.Provider {
    private static final long serialVersionUID = 5326735092324267367L;
    public static final String MIME_TYPE = "text/xml";
    public static final String xmlCommentAction = "xml-comment";
    public static final String xmlUncommentAction = "xml-uncomment";
    public static final String xmlTestAction = "xml-dump";
    public static Map settings;
    private static final boolean J2EE_LEXER_COLORING;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(XMLKit.class);
    }

    public Syntax createSyntax(Document doc) {
        Syntax syn = null;
        LegacySyntaxBridge bridge = (LegacySyntaxBridge)MimeLookup.getLookup((String)MIME_TYPE).lookup(LegacySyntaxBridge.class);
        if (bridge != null) {
            syn = bridge.createSyntax((EditorKit)((Object)this), doc, MIME_TYPE);
        }
        return syn != null ? syn : super.createSyntax(doc);
    }

    public Document createDefaultDocument() {
        if (J2EE_LEXER_COLORING) {
            XMLEditorDocument doc = new XMLEditorDocument(this.getContentType());
            doc.putProperty(Language.class, XMLTokenId.language());
            return doc;
        }
        return super.createDefaultDocument();
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        SyntaxSupport syn = null;
        LegacySyntaxBridge bridge = (LegacySyntaxBridge)MimeLookup.getLookup((String)MIME_TYPE).lookup(LegacySyntaxBridge.class);
        if (bridge != null) {
            syn = bridge.createSyntaxSupport((EditorKit)((Object)this), (Document)doc, MIME_TYPE);
        }
        return syn != null ? syn : super.createSyntaxSupport(doc);
    }

    public void install(JEditorPane c) {
        super.install(c);
        if (Boolean.getBoolean("netbeans.experimental.xml.nodeselectors")) {
            new NodeSelector(c);
        }
    }

    public static void setMap(Map map) {
        settings = map;
    }

    public Map getMap() {
        return settings;
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    protected Action[] createActions() {
        Action[] actions = new Action[]{new XMLCommentAction(), new XMLUncommentAction(), new ToggleBlockCommentAction((CommentHandler)new XmlCommentHandler()), new TestAction()};
        return TextAction.augmentList(super.createActions(), actions);
    }

    static {
        J2EE_LEXER_COLORING = Boolean.getBoolean("j2ee_lexer_coloring");
    }

    public class XMLEditorDocument
    extends NbEditorDocument {
        public XMLEditorDocument(Class kitClass) {
            super(kitClass);
        }

        public XMLEditorDocument(String mimeType) {
            super(mimeType);
        }
    }

    public static class TestAction
    extends XMLEditorAction {
        private static final long serialVersionUID = 4004056745446099L;

        public TestAction() {
            super(XMLKit.xmlTestAction);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target == null) {
                return;
            }
            if (!target.isEditable() || !target.isEnabled()) {
                this.problem(null);
                return;
            }
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            try {
                doc.dump(System.out);
                if (target == null) {
                    throw new BadLocationException(null, 0);
                }
            }
            catch (BadLocationException e) {
                this.problem(null);
            }
        }
    }

    public static class XMLUncommentAction
    extends XMLEditorAction {
        private static final String commentStartString = "<!--";
        private static final String commentEndString = "-->";
        private static final char[] commentStart = new char[]{'<', '!', '-', '-'};
        private static final char[] commentEnd = new char[]{'-', '-', '>'};
        static final long serialVersionUID = 40040567454546061L;

        public XMLUncommentAction() {
            super(XMLKit.xmlUncommentAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block12: {
                if (target == null) {
                    return;
                }
                if (!target.isEditable() || !target.isEnabled()) {
                    this.problem(null);
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                try {
                    if (caret.isSelectionVisible()) {
                        int startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                        int endPos = target.getSelectionEnd();
                        doc.atomicLock();
                        try {
                            if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                                --endPos;
                            }
                            int pos = startPos;
                            for (int lineCnt = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos); lineCnt > 0; --lineCnt) {
                                char[] startChars = doc.getChars(pos, 4);
                                char[] endChars = doc.getChars(Utilities.getRowEnd((BaseDocument)doc, (int)pos) - 3, 3);
                                if (startChars[0] == commentStart[0] && startChars[1] == commentStart[1] && startChars[2] == commentStart[2] && startChars[3] == commentStart[3] && endChars[0] == commentEnd[0] && endChars[1] == commentEnd[1] && endChars[2] == commentEnd[2]) {
                                    doc.remove(pos, 4);
                                    doc.remove(Utilities.getRowEnd((BaseDocument)doc, (int)pos) - 3, 3);
                                }
                                pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                            }
                            break block12;
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                    char[] startChars = doc.getChars(target.getSelectionStart(), 4);
                    char[] endChars = doc.getChars(Utilities.getRowEnd((BaseDocument)doc, (int)target.getSelectionStart()) - 3, 3);
                    if (startChars[0] == commentStart[0] && startChars[1] == commentStart[1] && startChars[2] == commentStart[2] && startChars[3] == commentStart[3] && endChars[0] == commentEnd[0] && endChars[1] == commentEnd[1] && endChars[2] == commentEnd[2]) {
                        doc.remove(target.getSelectionStart(), 4);
                        doc.remove(Utilities.getRowEnd((BaseDocument)doc, (int)target.getSelectionStart()) - 3, 3);
                    }
                }
                catch (BadLocationException e) {
                    this.problem(null);
                }
            }
        }
    }

    public static class XMLCommentAction
    extends XMLEditorAction {
        private static final long serialVersionUID = 4004056745446061L;
        private static final String commentStartString = "<!--";
        private static final String commentEndString = "-->";

        public XMLCommentAction() {
            super(XMLKit.xmlCommentAction);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block10: {
                if (target == null) {
                    return;
                }
                if (!target.isEditable() || !target.isEnabled()) {
                    this.problem(null);
                    return;
                }
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                try {
                    if (caret.isSelectionVisible()) {
                        int startPos = Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart());
                        int endPos = target.getSelectionEnd();
                        doc.atomicLock();
                        try {
                            if (endPos > 0 && Utilities.getRowStart((BaseDocument)doc, (int)endPos) == endPos) {
                                --endPos;
                            }
                            int pos = startPos;
                            for (int lineCnt = Utilities.getRowCount((BaseDocument)doc, (int)startPos, (int)endPos); lineCnt > 0; --lineCnt) {
                                doc.insertString(pos, commentStartString, null);
                                doc.insertString(Utilities.getRowEnd((BaseDocument)doc, (int)pos), commentEndString, null);
                                pos = Utilities.getRowStart((BaseDocument)doc, (int)pos, (int)1);
                            }
                            break block10;
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                    doc.insertString(Utilities.getRowStart((BaseDocument)doc, (int)target.getSelectionStart()), commentStartString, null);
                    doc.insertString(Utilities.getRowEnd((BaseDocument)doc, (int)target.getSelectionStart()), commentEndString, null);
                }
                catch (BadLocationException e) {
                    this.problem(null);
                }
            }
        }
    }

    public static abstract class XMLEditorAction
    extends BaseAction {
        public XMLEditorAction(String id) {
            super(id);
            String desc = NbBundle.getMessage(XMLKit.class, (String)id);
            if (desc != null) {
                this.putValue("ShortDescription", desc);
            }
        }

        protected void problem(String reason) {
            if (reason != null) {
                StatusDisplayer.getDefault().setStatusText("Cannot proceed: " + reason);
            }
            new Panel().getToolkit().beep();
        }
    }
}

