/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelUtils;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.openide.ErrorManager;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XMLDocumentModelProvider
implements DocumentModelProvider {
    private static final boolean debug = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.debug");
    private static final boolean measure = Boolean.getBoolean("org.netbeans.modules.xml.text.structure.measure");

    public void updateModel(DocumentModel.DocumentModelModificationTransaction dtm, DocumentModel model, DocumentModel.DocumentChange[] changes) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException {
        XMLSyntaxSupport sup;
        long a = System.currentTimeMillis();
        if (debug) {
            System.out.println("\n\n\n\n\n");
        }
        if (debug) {
            DocumentModelUtils.dumpElementStructure((DocumentElement)model.getRootElement());
        }
        if ((sup = XMLSyntaxSupport.getSyntaxSupport(model.getDocument())) == null) {
            return;
        }
        ArrayList regenerate = new ArrayList();
        for (int i = 0; i < changes.length; ++i) {
            DocumentModel.DocumentChange dch = changes[i];
            int changeOffset = dch.getChangeStart().getOffset();
            Exception[] thrown = new Exception[1];
            try {
                sup.runWithSequence(changeOffset, s -> {
                    try {
                        this.updateModelLocked(sup, regenerate, dtm, model, dch, s);
                    }
                    catch (DocumentModel.DocumentModelTransactionCancelledException | DocumentModelException ex) {
                        thrown[0] = ex;
                    }
                    return null;
                });
                if (thrown[0] == null) continue;
                if (thrown[0] instanceof DocumentModelException) {
                    throw (DocumentModelException)((Object)thrown[0]);
                }
                if (!(thrown[0] instanceof DocumentModel.DocumentModelTransactionCancelledException)) continue;
                throw (DocumentModel.DocumentModelTransactionCancelledException)((Object)thrown[0]);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        for (DocumentElement de : regenerate) {
            this.generateDocumentElements(dtm, model, de);
        }
        if (measure) {
            System.out.println("[xmlmodel] generated in " + (System.currentTimeMillis() - a));
        }
    }

    private void updateModelLocked(XMLSyntaxSupport sup, ArrayList regenerate, DocumentModel.DocumentModelModificationTransaction dtm, DocumentModel model, DocumentModel.DocumentChange dch, TokenSequence seq) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException, BadLocationException {
        DocumentElement toRegenerate;
        DocumentElement leaf;
        int changeOffset;
        block34: {
            changeOffset = dch.getChangeStart().getOffset();
            int changeLength = dch.getChangeLength();
            toRegenerate = leaf = model.getLeafElementForOffset(changeOffset);
            if (debug) {
                System.out.println("");
            }
            if (debug) {
                System.out.println(dch);
            }
            try {
                if (debug) {
                    System.out.println("inserted text:'" + model.getDocument().getText(changeOffset, changeLength) + "'");
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (debug) {
                System.out.println("leaf = " + leaf);
            }
            boolean textOnly = false;
            boolean attribsOnly = false;
            seq.move(changeOffset);
            block8: while (seq.moveNext()) {
                Token ti = seq.token();
                XMLTokenId id = (XMLTokenId)ti.id();
                switch (id) {
                    case TEXT: 
                    case DECLARATION: 
                    case BLOCK_COMMENT: 
                    case PI_CONTENT: 
                    case CDATA_SECTION: {
                        textOnly = true;
                        break block8;
                    }
                    case ARGUMENT: 
                    case OPERATOR: 
                    case VALUE: {
                        attribsOnly = true;
                        break block8;
                    }
                    default: {
                        continue block8;
                    }
                }
            }
            if (textOnly && (leaf.getType().equals("content") || leaf.getType().equals("doctype") || leaf.getType().equals("pi") || leaf.getType().equals("comment") || leaf.getType().equals("cdata"))) {
                if (debug) {
                    System.out.println("ONLY CONTENT UPDATE!!!");
                }
                dtm.updateDocumentElementText(leaf);
                if (dch.getChangeLength() == 1) {
                    return;
                }
            }
            if ((attribsOnly || dch.getChangeType() == 1) && (leaf.getType().equals("tag") || leaf.getType().equals("empty_tag"))) {
                if (debug) {
                    System.out.println("POSSIBLE ATTRIBS UPDATE!!!");
                }
                try {
                    SyntaxElement sel = sup.getElementChain(leaf.getStartOffset() + 1);
                    if (!sup.isStartTag(sel) && !sup.isEmptyTag(sel)) break block34;
                    Map newAttrs = this.createAttributesMap((Node)sel.getNode());
                    AttributeSet existing = leaf.getAttributes();
                    boolean update = false;
                    if (existing.getAttributeCount() == newAttrs.size()) {
                        for (String attrName : newAttrs.keySet()) {
                            String attrValue = (String)newAttrs.get(attrName);
                            if (attrName == null || attrValue == null || existing.containsAttribute(attrName, attrValue)) continue;
                            update = true;
                            break;
                        }
                    } else {
                        update = true;
                    }
                    if (update) {
                        dtm.updateDocumentElementAttribs(leaf, newAttrs);
                    }
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify(16, (Throwable)ble);
                }
            }
        }
        if (leaf.getStartOffset() == leaf.getEndOffset() || changeOffset == leaf.getStartOffset() || changeOffset == leaf.getEndOffset()) {
            toRegenerate = leaf.getParentElement();
        } else if (leaf.getType().equals("content")) {
            while ((toRegenerate = toRegenerate.getParentElement()) != null && toRegenerate.getType().equals("content")) {
            }
            if (toRegenerate == null) {
                toRegenerate = model.getRootElement();
            }
        }
        if (toRegenerate == null) {
            toRegenerate = model.getRootElement();
        }
        Iterator itr = regenerate.iterator();
        boolean hasAncestor = false;
        while (itr.hasNext()) {
            DocumentElement de = (DocumentElement)itr.next();
            if (!de.equals((Object)toRegenerate) && !model.isDescendantOf(de, toRegenerate)) continue;
            hasAncestor = true;
            break;
        }
        if (!hasAncestor) {
            ArrayList<DocumentElement> toRemove = new ArrayList<DocumentElement>();
            for (DocumentElement de : regenerate) {
                if (!model.isDescendantOf(toRegenerate, de)) continue;
                toRemove.add(de);
            }
            regenerate.removeAll(toRemove);
            regenerate.add(toRegenerate);
            if (debug) {
                System.out.println("===================================================================");
            }
            if (debug) {
                System.out.println("change happened in " + leaf);
            }
            if (debug) {
                System.out.println("we will regenerate its parent " + toRegenerate);
            }
        }
    }

    private void generateDocumentElements(DocumentModel.DocumentModelModificationTransaction dtm, DocumentModel model, DocumentElement de) throws DocumentModelException, DocumentModel.DocumentModelTransactionCancelledException {
        int startOffset = de.getStartOffset();
        int endOffset = de.getEndOffset();
        BaseDocument doc = (BaseDocument)model.getDocument();
        XMLSyntaxSupport sup = XMLSyntaxSupport.createSyntaxSupport((Document)doc);
        if (debug) {
            System.out.println("[XMLDocumentModelProvider] regenerating " + de);
        }
        TreeSet<DocumentElement> addedElements = new TreeSet<DocumentElement>(DocumentModel.ELEMENTS_COMPARATOR);
        ArrayList<DocumentElement> skipped = new ArrayList<DocumentElement>();
        try {
            Stack<SyntaxElement> elementsStack = new Stack<SyntaxElement>();
            SyntaxElement sel = sup.getElementChain(Math.min(doc.getLength(), startOffset + 1));
            while (sel != null && this.getSyntaxElementEndOffset(sel) <= endOffset) {
                if (sel.getType() == -1) {
                    int to;
                    if (debug) {
                        System.out.println("Error found! => adding error element.");
                    }
                    String errorText = doc.getText(sel.getElementOffset(), sel.getElementLength());
                    int from = sel.getElementOffset();
                    if (from == (to = this.getSyntaxElementEndOffset(sel))) {
                        ++to;
                    }
                    addedElements.add(dtm.addDocumentElement(errorText, "error", Collections.EMPTY_MAP, from, to));
                }
                if (sup.isStartTag(sel)) {
                    SyntaxElement endTagCheck;
                    String nn = sel.getNode().getNodeName();
                    DocumentElement tagDE = DocumentModelUtils.findElement((DocumentModel)model, (int)sel.getElementOffset(), (String)nn, (String)"tag");
                    if (tagDE != null && !tagDE.equals((Object)de) && sup.isEndTag(endTagCheck = sup.getElementChain(Math.min(doc.getLength(), tagDE.getEndOffset() + 1))) && endTagCheck.getNode().getNodeName().equals(nn)) {
                        if (debug) {
                            System.out.println("found existing element " + tagDE + " => skipping");
                        }
                        sel = endTagCheck.getNext();
                        skipped.add(tagDE);
                        continue;
                    }
                    elementsStack.push(sel);
                } else if (sup.isEndTag(sel)) {
                    if (!elementsStack.isEmpty()) {
                        SyntaxElement latest = (SyntaxElement)elementsStack.peek();
                        String nn = latest.getNode().getNodeName();
                        if (sel.getNode().getNodeName().equals(nn)) {
                            Map attribs = this.createAttributesMap((Node)latest.getNode());
                            addedElements.add(dtm.addDocumentElement(nn, "tag", attribs, latest.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                            elementsStack.pop();
                        } else {
                            ArrayList<SyntaxElement> savedElements = new ArrayList<SyntaxElement>();
                            boolean foundStartTag = false;
                            while (!elementsStack.isEmpty()) {
                                SyntaxElement s = (SyntaxElement)elementsStack.pop();
                                savedElements.add(s);
                                int soff = s.getElementOffset();
                                String sn = s.getNode().getNodeName();
                                String en = sel.getNode().getNodeName();
                                if (!sup.isStartTag(s) || !sn.equals(en)) continue;
                                Map attribs = this.createAttributesMap((Node)s.getNode());
                                addedElements.add(dtm.addDocumentElement(sn, "tag", attribs, soff, this.getSyntaxElementEndOffset(sel)));
                                foundStartTag = true;
                                break;
                            }
                            if (!foundStartTag) {
                                for (int i = savedElements.size() - 1; i >= 0; --i) {
                                    elementsStack.push((SyntaxElement)savedElements.get(i));
                                }
                            }
                        }
                    }
                } else if (sup.isEmptyTag(sel)) {
                    Map attribs = this.createAttributesMap((Node)sel.getNode());
                    addedElements.add(dtm.addDocumentElement(sel.getNode().getNodeName(), "empty_tag", attribs, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                } else {
                    switch (sel.getType()) {
                        case 4: {
                            addedElements.add(dtm.addDocumentElement("cdata", "cdata", Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                            break;
                        }
                        case 7: {
                            String nodeName = ((ProcessingInstruction)sel.getNode()).getNodeName();
                            if (nodeName != null) {
                                addedElements.add(dtm.addDocumentElement(nodeName, "pi", Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                            }
                            break;
                        }
                        case 10: {
                            String nodeName = ((DocumentType)sel.getNode()).getName();
                            if (nodeName != null) {
                                addedElements.add(dtm.addDocumentElement(nodeName, "doctype", Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                            }
                            break;
                        }
                        case 8: {
                            addedElements.add(dtm.addDocumentElement("comment", "comment", Collections.EMPTY_MAP, sel.getElementOffset(), this.getSyntaxElementEndOffset(sel)));
                            break;
                        }
                        default: {
                            int from = sel.getElementOffset();
                            int to = this.getSyntaxElementEndOffset(sel) + 1;
                            if (from >= to) break;
                            addedElements.add(dtm.addDocumentElement("...", "content", Collections.EMPTY_MAP, from, to));
                        }
                    }
                }
                try {
                    SyntaxElement prev = null;
                    int add = 0;
                    while ((prev = sup.getElementChain(sel.getElementOffset() + sel.getElementLength() + ++add)) != null && sel.getElementOffset() >= prev.getElementOffset()) {
                    }
                    sel = prev;
                }
                catch (BadLocationException ble) {
                    sel = null;
                }
            }
            List existingElements = this.getDescendantsOfNotSkippedElements(de, skipped);
            existingElements.add(de);
            for (DocumentElement d : existingElements) {
                if (addedElements.contains(d)) continue;
                dtm.removeDocumentElement(d, false);
                if (!debug) continue;
                System.out.println("[xml model] removed element " + d);
            }
        }
        catch (BadLocationException e) {
            throw new DocumentModelException("Error occurred during generation of Document elements", (Throwable)e);
        }
    }

    private List getDescendantsOfNotSkippedElements(DocumentElement de, List skippedElements) {
        ArrayList<DocumentElement> desc = new ArrayList<DocumentElement>();
        for (DocumentElement child : de.getChildren()) {
            if (skippedElements.contains(child)) continue;
            desc.add(child);
            desc.addAll(this.getDescendantsOfNotSkippedElements(child, skippedElements));
        }
        return desc;
    }

    private int getSyntaxElementEndOffset(SyntaxElement sel) {
        return sel.getElementOffset() + sel.getElementLength() - 1;
    }

    private Map createAttributesMap(Node tag) {
        if (tag.getAttributes().getLength() == 0) {
            return Collections.EMPTY_MAP;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(tag.getAttributes().getLength());
        for (int i = 0; i < tag.getAttributes().getLength(); ++i) {
            Attr attr = (Attr)tag.getAttributes().item(i);
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }
}

