/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.dom;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.spi.dom.NamedNodeMapImpl;
import org.netbeans.modules.xml.spi.dom.ROException;
import org.netbeans.modules.xml.spi.dom.UOException;
import org.netbeans.modules.xml.text.api.dom.TagElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.dom.AttrImpl;
import org.netbeans.modules.xml.text.dom.EndTag;
import org.netbeans.modules.xml.text.dom.StartTag;
import org.netbeans.modules.xml.text.dom.SyntaxNode;
import org.openide.util.Exceptions;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Tag
extends SyntaxNode
implements Element,
TagElement {
    protected NamedNodeMap domAttributes;
    protected String name;

    Tag(XMLSyntaxSupport support, Token from, int start, int end, String name) {
        super(support, from, start, end);
        this.name = name;
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public final String getNodeName() {
        return this.getTagName();
    }

    @Override
    public final String getTagName() {
        return this.name;
    }

    private Map parseAttributes(TokenSequence ts) {
        LinkedHashMap<Object, AttrImpl> map = new LinkedHashMap<Object, AttrImpl>(3);
        int index = 0;
        block0: while (ts.moveNext()) {
            Token next = ts.token();
            XMLTokenId id = (XMLTokenId)next.id();
            if (id == XMLTokenId.ARGUMENT) {
                Token attributeStart = next;
                String name = next.text().toString();
                while (next.id() != XMLTokenId.VALUE) {
                    if (ts.moveNext() && (next = ts.token()).id() != XMLTokenId.ERROR) continue;
                    break block0;
                }
                String image = next.text().toString();
                char test = image.charAt(0);
                if (image.length() == 1 && (test == '\"' || test == '\'')) {
                    if (!ts.moveNext()) break;
                    next = ts.token();
                }
                String value = next.text().toString();
                Object key = NamedNodeMapImpl.createKey((String)name);
                map.put(key, new AttrImpl(this.support, (Token<XMLTokenId>)attributeStart, this, index++));
                next = Tag.skipAttributeValue(ts, test);
                if (next != null) continue;
                break;
            }
            if (id == XMLTokenId.WS) continue;
        }
        return map;
    }

    private static Token skipAttributeValue(TokenSequence ts, char delim) {
        do {
            Token t;
            if ((t = ts.token()).text().charAt(t.length() - 1) != delim) continue;
            return ts.moveNext() ? ts.token() : null;
        } while (ts.moveNext());
        return null;
    }

    @Override
    public synchronized NamedNodeMap getAttributes() {
        try {
            return new NamedNodeMapImpl(this.support.runWithSequence(this.offset, ts -> this.parseAttributes(ts)));
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    @Override
    public String getAttribute(String name) {
        Attr attribute = this.getAttributeNode(name);
        return attribute != null ? attribute.getValue() : "";
    }

    @Override
    public final void setAttribute(String name, String value) {
    }

    @Override
    public final void removeAttribute(String name) {
        throw new ROException();
    }

    @Override
    public Attr getAttributeNode(String name) {
        NamedNodeMap map = this.getAttributes();
        Node node = map.getNamedItem(name);
        return (Attr)node;
    }

    @Override
    public final Attr setAttributeNode(Attr attribute) {
        throw new ROException();
    }

    @Override
    public final Attr removeAttributeNode(Attr attribute) {
        throw new ROException();
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        throw new ROException();
    }

    @Override
    public Node getPreviousSibling() {
        SyntaxNode prev = this.getStartTag();
        if (prev == null) {
            return null;
        }
        if ((prev = Tag.findPrevious(prev)) instanceof StartTag) {
            return null;
        }
        return prev;
    }

    @Override
    public Node getNextSibling() {
        SyntaxNode next = this.getEndTag();
        if (next == null) {
            return null;
        }
        if ((next = Tag.findNext(next)) instanceof EndTag) {
            return null;
        }
        return next;
    }

    @Override
    public Node getFirstChild() {
        NodeList list = this.getChildNodes();
        if (list.getLength() == 0) {
            return null;
        }
        return this.getChildNodes().item(0);
    }

    @Override
    public Node getLastChild() {
        NodeList list = this.getChildNodes();
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(list.getLength());
    }

    @Override
    public abstract Tag getStartTag();

    @Override
    public abstract Tag getEndTag();

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        throw new UOException();
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) {
        throw new UOException();
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public boolean hasAttribute(String name) {
        throw new UOException();
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Tag) {
            Tag tag = (Tag)obj;
            Tag t1 = tag.getStartTag();
            Tag t2 = this.getStartTag();
            if (t1 == null || t2 == null) {
                return false;
            }
            return t1.superEquals(t2);
        }
        return false;
    }

    private boolean superEquals(Tag tag) {
        return super.equals(tag);
    }

    @Override
    public final int hashCode() {
        Tag tag = this.getStartTag();
        if (tag == null || tag == this) {
            return super.hashCode();
        }
        return tag.hashCode();
    }
}

