/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.impl.AXIComponentProxy;

public class SchemaUpdate {
    private List<UpdateUnit> units = new ArrayList<UpdateUnit>();
    private HashMap<AXIComponent, List<AXIComponent>> uniqueMap = new HashMap();
    private int count = 0;

    public Collection<UpdateUnit> getUpdateUnits() {
        return Collections.unmodifiableList(this.units);
    }

    public void addUpdateUnit(UpdateUnit uu) {
        this.units.add(uu);
    }

    public UpdateUnit createUpdateUnit(UpdateUnit.Type type, AXIComponent source, Object oldValue, Object newValue, String propertyName) {
        AXIComponent key = null;
        if (type == UpdateUnit.Type.CHILD_MODIFIED) {
            key = source;
        } else if (type == UpdateUnit.Type.CHILD_ADDED) {
            key = (AXIComponent)newValue;
        } else if (type == UpdateUnit.Type.CHILD_DELETED) {
            key = (AXIComponent)oldValue;
        }
        if (key instanceof AXIComponentProxy) {
            key = key.getOriginal();
        }
        if (key != null) {
            List<AXIComponent> items = this.uniqueMap.get(key);
            if (items == null) {
                items = new ArrayList<AXIComponent>();
                this.uniqueMap.put(key, items);
            }
            items.add(key);
            return new UpdateUnit(String.valueOf(this.count++), type, source, oldValue, newValue, propertyName);
        }
        return null;
    }

    public static class UpdateUnit {
        private String id;
        private Type type;
        private AXIComponent source;
        private Object oldValue;
        private Object newValue;
        private String propertyName;

        public UpdateUnit(String id, Type type, AXIComponent source, Object oldValue, Object newValue, String propertyName) {
            this.id = id;
            this.type = type;
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.propertyName = propertyName;
        }

        public String getId() {
            return this.id;
        }

        public AXIComponent getSource() {
            return this.source;
        }

        public Type getType() {
            return this.type;
        }

        public Object getOldValue() {
            return this.oldValue;
        }

        public Object getNewValue() {
            return this.newValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public static enum Type {
            CHILD_ADDED,
            CHILD_DELETED,
            CHILD_MODIFIED;

        }
    }
}

