/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNode;
import org.netbeans.modules.websvc.saas.util.SaasTransferable;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class WadlMethodNode
extends AbstractNode {
    private WadlSaasMethod method;
    private Transferable transferable;
    private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/saas/ui/resources/method.png");

    public WadlMethodNode(WadlSaasMethod method) {
        this(method, new InstanceContent());
    }

    public WadlMethodNode(WadlSaasMethod method, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.method = method;
        content.add((Object)method);
        this.transferable = ExTransferable.create((Transferable)new SaasTransferable((Object)method, SaasTransferable.WADL_METHOD_FLAVORS));
    }

    public String getDisplayName() {
        return this.method.getDisplayName();
    }

    public String getShortDescription() {
        if (this.method.getMethod() != null) {
            return this.method.getMethod().getDocumentation();
        }
        return SaasUtil.getSignature((WadlSaasMethod)this.method);
    }

    public Image getIcon(int type) {
        return ICON;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        List<Action> actions = SaasNode.getActions(this.getLookup());
        return actions.toArray(new Action[actions.size()]);
    }

    public Transferable clipboardCopy() throws IOException {
        if (this.method.getSaas().getState() != Saas.State.READY) {
            this.method.getSaas().toStateReady(false);
            return super.clipboardCopy();
        }
        return SaasTransferable.addFlavors((Transferable)this.transferable);
    }
}

