/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.rest.nodes.TestRestServicesAction;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.TestRestTargetPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.LineCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Utils {
    private static RequestProcessor TEST_CLIENT_RQ;

    public static String stripPackageName(String name) {
        int genericIndex = name.indexOf("<");
        int index = 0;
        if (genericIndex > 0) {
            String className = name.substring(0, genericIndex);
            index = className.lastIndexOf(".");
        } else {
            index = name.lastIndexOf(".");
        }
        if (index > 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public static Collection<String> sortKeys(Collection<String> keys) {
        TreeSet<String> sortedKeys = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                return str1.compareTo(str2);
            }
        });
        sortedKeys.addAll(keys);
        return sortedKeys;
    }

    public static void showMethod(FileObject source, String methodName) {
        try {
            LineCookie lc;
            DataObject dataObj = DataObject.find((FileObject)source);
            JavaSource javaSource = JavaSource.forFileObject((FileObject)source);
            SaveCookie sc = (SaveCookie)dataObj.getCookie(SaveCookie.class);
            if (sc != null) {
                sc.save();
            }
            if ((lc = (LineCookie)dataObj.getCookie(LineCookie.class)) != null) {
                final long[] position = JavaSourceHelper.getPosition(javaSource, methodName);
                final Line line = lc.getLineSet().getOriginal((int)position[0]);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.NONE, (int)position[1]);
                    }
                });
            }
        }
        catch (Exception de) {
            Exceptions.printStackTrace((Throwable)de);
        }
    }

    public static Method getValueOfMethod(Class type) {
        try {
            Method method = type.getDeclaredMethod("valueOf", String.class);
            if (method == null || !Modifier.isStatic(method.getModifiers())) {
                return null;
            }
            return method;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getConstructorWithStringParam(Class type) {
        try {
            return type.getConstructor(String.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Project[] getProjectsFromLookup(Lookup lookup) {
        HashSet<Project> result = new HashSet<Project>();
        for (Project p : lookup.lookupAll(Project.class)) {
            result.add(p);
        }
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            result.add(p);
        }
        Project[] projectsArray = result.toArray(new Project[0]);
        return projectsArray;
    }

    public static FileObject findBuildXml(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    public static void testRestWebService(Project project) {
        if (project == null) {
            return;
        }
        TestRestTargetPanel panel = new TestRestTargetPanel(project);
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(Utils.class, (String)"TTL_SelectTarget"));
        panel.setDescriptor(descriptor);
        if (!DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor).equals(NotifyDescriptor.OK_OPTION)) {
            return;
        }
        if (panel.isRemote()) {
            Utils.generateRemoteTester(project, panel.getProject());
        } else {
            Utils.generateLocalTester(project);
        }
    }

    private static void generateRemoteTester(final Project restProject, Project remoteProject) {
        final RestSupport rs = (RestSupport)remoteProject.getLookup().lookup(RestSupport.class);
        final RestSupport localSupport = (RestSupport)restProject.getLookup().lookup(RestSupport.class);
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)remoteProject).getSourceGroups("doc_root");
        SourceGroup sourceGroup = sourceGroups[0];
        final FileObject rootFolder = sourceGroup.getRootFolder();
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                final FileObject[] testFO = new FileObject[1];
                AtomicBoolean cancel = new AtomicBoolean(false);
                BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            testFO[0] = rs.generateTestClient(FileUtil.toFile((FileObject)rootFolder), localSupport.getBaseURL());
                        }
                        catch (IOException e) {
                            Logger.getLogger(Utils.class.getName()).log(Level.WARNING, null, e);
                        }
                    }
                }, (String)NbBundle.getMessage(Utils.class, (String)"TTL_GenTestClient"), (AtomicBoolean)cancel, (boolean)false);
                if (cancel.get() || testFO[0] == null) {
                    return;
                }
                Utils.getTestClientRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            localSupport.deploy();
                            rs.deploy();
                            URL url = new URL(MiscUtilities.getContextRootURL((Project)restProject) + testFO[0].getNameExt());
                            if (url != null) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                            }
                        }
                        catch (IOException e) {
                            Logger.getLogger(Utils.class.getName()).log(Level.WARNING, null, e);
                        }
                    }
                });
            } else {
                URL url;
                FileObject testFO = rs.generateTestClient(FileUtil.toFile((FileObject)rootFolder), localSupport.getBaseURL());
                localSupport.deploy();
                if (localSupport != rs) {
                    rs.deploy();
                }
                if ((url = new URL(MiscUtilities.getContextRootURL((Project)restProject) + testFO.getNameExt())) != null) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
            }
        }
        catch (IOException e) {
            Logger.getLogger(TestRestServicesAction.class.getName()).log(Level.WARNING, null, e);
        }
    }

    private static void generateLocalTester(final Project prj) {
        block13: {
            final FileObject buildFo = Utils.findBuildXml(prj);
            if (buildFo != null) {
                try {
                    Properties[] props;
                    if (SwingUtilities.isEventDispatchThread()) {
                        props = new Properties[1];
                        AtomicBoolean cancel = new AtomicBoolean(false);
                        BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    props[0] = Utils.setupTestRestBeans(prj);
                                }
                                catch (IOException e) {
                                    Logger.getLogger(Utils.class.getName()).log(Level.WARNING, null, e);
                                }
                            }
                        }, (String)NbBundle.getMessage(Utils.class, (String)"TTL_GenTestClient"), (AtomicBoolean)cancel, (boolean)false);
                        if (cancel.get() || props[0] == null) {
                            return;
                        }
                        Utils.getTestClientRequestProcessor().post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{"test-restbeans"}, (Properties)props[0]);
                                }
                                catch (IOException e) {
                                    Logger.getLogger(Utils.class.getName()).log(Level.WARNING, null, e);
                                }
                            }
                        });
                        break block13;
                    }
                    props = Utils.setupTestRestBeans(prj);
                    ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{"test-restbeans"}, (Properties)props);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                final RestSupport rs = (RestSupport)prj.getLookup().lookup(RestSupport.class);
                if (rs != null) {
                    try {
                        if (SwingUtilities.isEventDispatchThread()) {
                            final FileObject[] testFO = new FileObject[1];
                            AtomicBoolean cancel = new AtomicBoolean(false);
                            BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        testFO[0] = rs.generateTestClient(rs.getLocalTargetTestRest(), rs.getBaseURL());
                                    }
                                    catch (IOException e) {
                                        Logger.getLogger(Utils.class.getName()).log(Level.WARNING, null, e);
                                    }
                                }
                            }, (String)NbBundle.getMessage(Utils.class, (String)"TTL_GenTestClient"), (AtomicBoolean)cancel, (boolean)false);
                            if (cancel.get() || testFO[0] == null) {
                                return;
                            }
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        URL url;
                                        rs.deploy();
                                        if (testFO != null && (url = testFO[0].toURL()) != null) {
                                            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                                        }
                                    }
                                    catch (IOException e) {
                                        Logger.getLogger(Utils.class.getName()).log(Level.WARNING, null, e);
                                    }
                                }
                            });
                        } else {
                            URL url;
                            FileObject testFO = rs.generateTestClient(rs.getLocalTargetTestRest(), rs.getBaseURL());
                            rs.deploy();
                            if (testFO != null && (url = testFO.toURL()) != null) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                            }
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        Object[] params = new Object[]{"JAX-RS", "TEST REST"};
        LogUtils.logWsAction((Object[])params);
    }

    private static Properties setupTestRestBeans(Project project) throws IOException {
        Properties p = new Properties();
        p.setProperty("base.url.token", "___BASE_URL___");
        RestSupport rs = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (rs != null) {
            try {
                String applicationPath = rs.getApplicationPath();
                if (applicationPath != null) {
                    if (!applicationPath.startsWith("/")) {
                        applicationPath = "/" + applicationPath;
                    }
                    p.setProperty("rest.application.path", applicationPath);
                }
                File testdir = rs.getLocalTargetTestRest();
                FileObject testFO = MiscUtilities.generateTestClient((File)testdir);
                p.setProperty("restbeans.test.url", testFO.toURL().toString());
                p.setProperty("restbeans.test.file", FileUtil.toFile((FileObject)testFO).getAbsolutePath());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return p;
    }

    private static RequestProcessor getTestClientRequestProcessor() {
        assert (SwingUtilities.isEventDispatchThread());
        if (TEST_CLIENT_RQ == null) {
            TEST_CLIENT_RQ = new RequestProcessor("REST-Test-Client-RQ");
        }
        return TEST_CLIENT_RQ;
    }
}

