/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OpenCookieFactory {
    public static OpenCookie create(Project project, String className) {
        return OpenCookieFactory.create(project, className, null);
    }

    public static OpenCookie create(Project project, String className, String methodName) {
        return new OpenCookieImpl(project, className, methodName);
    }

    private static class OpenCookieImpl
    implements OpenCookie {
        private String className;
        private String methodName;
        private Project project;

        public OpenCookieImpl(Project project, String className, String methodName) {
            this.project = project;
            this.className = className;
            this.methodName = methodName;
        }

        public void open() {
            if (SwingUtilities.isEventDispatchThread()) {
                AtomicBoolean cancel = new AtomicBoolean();
                BaseProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        this.doOpen();
                    }
                }, (String)NbBundle.getMessage(OpenCookieFactory.class, (String)"TXT_OpenResource"), (AtomicBoolean)cancel, (boolean)false);
            } else {
                this.doOpen();
            }
        }

        private void doOpen() {
            try {
                DataObject dataObj;
                FileObject source = SourceGroupSupport.getFileObjectFromClassName(this.className, this.project);
                if (source != null && (dataObj = DataObject.find((FileObject)source)) != null) {
                    JavaSource javaSource = JavaSource.forFileObject((FileObject)source);
                    final long[] position = JavaSourceHelper.getPosition(javaSource, this.methodName);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LineCookie lc;
                            OpenCookie oc = (OpenCookie)dataObj.getCookie(OpenCookie.class);
                            if (oc != null) {
                                oc.open();
                            }
                            if ((lc = (LineCookie)dataObj.getCookie(LineCookie.class)) != null) {
                                Line line = lc.getLineSet().getOriginal((int)position[0]);
                                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.NONE, (int)position[1]);
                            }
                        }
                    });
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

