/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.codegen.model.Method;
import org.netbeans.modules.websvc.rest.codegen.model.Resource;
import org.netbeans.modules.websvc.rest.codegen.model.ResourceModel;
import org.netbeans.modules.websvc.rest.codegen.model.RestEntity;
import org.netbeans.modules.websvc.rest.codegen.model.State;
import org.netbeans.modules.websvc.rest.support.AbstractTask;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.openide.util.NbBundle;

public class SourceModeler
extends ResourceModel {
    private static final Logger LOG = Logger.getLogger(SourceModeler.class.getCanonicalName());
    private Project project;
    private Set<String> resourceFqns;

    public SourceModeler(Project p) {
        this.project = p;
    }

    @Override
    public State validate() {
        return State.VALID;
    }

    @Override
    public void build() throws IOException {
        State state = this.validate();
        if (state != State.VALID) {
            throw new IOException(NbBundle.getMessage(AbstractPanel.class, (String)"MSG_ProjectsWithoutREST") + ", " + state.value());
        }
        List<JavaSource> sources = JavaSourceHelper.getJavaSources(this.project);
        for (JavaSource src : sources) {
            Resource r;
            String className;
            if (JavaSourceHelper.isEntity(src) || (className = JavaSourceHelper.getClassNameQuietly(src)) == null || !RestUtils.isStaticResource(src) || (r = this.createResource(src)) == null) continue;
            this.addResource(r);
        }
    }

    private Resource createResource(JavaSource rSrc) throws IOException {
        String name = null;
        String path = null;
        String template = RestUtils.findUri(rSrc);
        this.resourceFqns = new HashSet<String>();
        if (template != null) {
            path = template;
            name = path;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            Resource r = new Resource(ClientStubModel.normalizeName(name), path);
            this.buildResource(r, rSrc);
            return r;
        }
        return null;
    }

    private void buildResource(final Resource resource, JavaSource src) throws IOException {
        resource.setSource(src);
        try {
            src.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    Collection methods = SourceModeler.this.doBuildResource(resource, classElement, controller, SourceModeler.this.getBoxedPrimitives(controller));
                    for (Method method : methods) {
                        resource.addMethod(method);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
    }

    private Collection<TypeMirror> getBoxedPrimitives(CompilationController controller) {
        TypeKind[] values = TypeKind.values();
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>(values.length);
        for (TypeKind typeKind : values) {
            if (!typeKind.isPrimitive()) continue;
            PrimitiveType primitiveType = controller.getTypes().getPrimitiveType(typeKind);
            TypeElement boxedClass = controller.getTypes().boxedClass(primitiveType);
            result.add(boxedClass.asType());
        }
        return result;
    }

    private Collection<Method> doBuildResource(Resource resource, TypeElement clazz, CompilationController controller, Collection<TypeMirror> boxedPrimitives) {
        String fqn = clazz.getQualifiedName().toString();
        if (this.resourceFqns.contains(fqn)) {
            return Collections.emptyList();
        }
        this.resourceFqns.add(fqn);
        LinkedList<Method> result = new LinkedList<Method>();
        List<ExecutableElement> methods = ElementFilter.methodsIn(controller.getElements().getAllMembers(clazz));
        for (ExecutableElement method : methods) {
            List<? extends AnnotationMirror> annotationMirrors = controller.getElements().getAllAnnotationMirrors(method);
            HashMap<String, AnnotationMirror> restAnnotations = new HashMap<String, AnnotationMirror>();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                TypeElement annotation;
                String fqnAnnotation;
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                Element annotationElement = annotationType.asElement();
                if (!(annotationElement instanceof TypeElement) || !this.isRestAnnotation(fqnAnnotation = (annotation = (TypeElement)annotationElement).getQualifiedName().toString())) continue;
                restAnnotations.put(fqnAnnotation, annotationMirror);
            }
            Collection<Method> collection = this.createRestMethods(resource, restAnnotations, clazz, method, controller, boxedPrimitives);
            result.addAll(collection);
        }
        return result;
    }

    private Collection<Method> createRestMethods(Resource resource, Map<String, AnnotationMirror> restAnnotations, TypeElement clazz, ExecutableElement method, CompilationController controller, Collection<TypeMirror> boxedPrimitives) {
        AnnotationMirror produceAnnotion;
        AnnotationMirror pathAnnotation = restAnnotations.get("jakarta.ws.rs.Path");
        if (pathAnnotation == null) {
            pathAnnotation = restAnnotations.get("javax.ws.rs.Path");
        }
        if ((produceAnnotion = restAnnotations.get("jakarta.ws.rs.Produces")) == null) {
            produceAnnotion = restAnnotations.get("javax.ws.rs.Produces");
        }
        AnnotationMirror consumeAnnotion = restAnnotations.get("jakarta.ws.rs.Consumes");
        if (produceAnnotion == null) {
            consumeAnnotion = restAnnotations.get("javax.ws.rs.Consumes");
        }
        AnnotationMirror getAnnotion = restAnnotations.get("jakarta.ws.rs.GET");
        if (produceAnnotion == null) {
            getAnnotion = restAnnotations.get("javax.ws.rs.GET");
        }
        AnnotationMirror postAnnotion = restAnnotations.get("jakarta.ws.rs.POST");
        if (produceAnnotion == null) {
            postAnnotion = restAnnotations.get("javax.ws.rs.POST");
        }
        AnnotationMirror putAnnotion = restAnnotations.get("jakarta.ws.rs.PUT");
        if (produceAnnotion == null) {
            putAnnotion = restAnnotations.get("javax.ws.rs.PUT");
        }
        AnnotationMirror deleteAnnotion = restAnnotations.get("jakarta.ws.rs.DELETE");
        if (produceAnnotion == null) {
            deleteAnnotion = restAnnotations.get("javax.ws.rs.DELETE");
        }
        AnnotationMirror httpAnnotation = this.chooseNotNull(getAnnotion, postAnnotion, putAnnotion, deleteAnnotion);
        TypeMirror methodMirror = controller.getTypes().asMemberOf((DeclaredType)clazz.asType(), method);
        TypeMirror returnTypeMirror = ((ExecutableType)methodMirror).getReturnType();
        if (pathAnnotation != null) {
            Object value;
            Map<? extends ExecutableElement, ? extends AnnotationValue> values = pathAnnotation.getElementValues();
            String path = null;
            Iterator<? extends AnnotationValue> iterator = values.values().iterator();
            if (iterator.hasNext() && (value = iterator.next().getValue()) != null) {
                path = value.toString();
            }
            if (path == null) {
                return Collections.emptyList();
            }
            if (httpAnnotation != null) {
                Method restMethod = this.createMethod(method.getSimpleName().toString(), clazz, controller);
                StringBuilder resourcePath = new StringBuilder();
                if (resource.getName() == null) {
                    resourcePath.append(resource.getPath());
                    if (!resource.getPath().endsWith("/")) {
                        resourcePath.append('/');
                    }
                }
                resourcePath.append(path);
                this.configureMethod(restMethod, produceAnnotion, consumeAnnotion, httpAnnotation, resourcePath.toString(), method, (ExecutableType)methodMirror, controller, boxedPrimitives);
                return Collections.singletonList(restMethod);
            }
            Element returnElement = controller.getTypes().asElement(returnTypeMirror);
            if (returnElement instanceof TypeElement) {
                String resourePath = resource.getPath();
                if (resource.getName() != null) {
                    resourePath = "";
                }
                StringBuilder newPath = new StringBuilder(resourePath);
                if (!resource.getPath().endsWith("/")) {
                    newPath.append('/');
                }
                newPath.append(path);
                Resource resourceLocator = new Resource(null, newPath.toString());
                return this.doBuildResource(resourceLocator, (TypeElement)returnElement, controller, boxedPrimitives);
            }
            return Collections.emptyList();
        }
        if (httpAnnotation != null) {
            Method restMethod = this.createMethod(method.getSimpleName().toString(), clazz, controller);
            String resourcePath = resource.getPath();
            if (resource.getName() != null) {
                resourcePath = null;
            }
            this.configureMethod(restMethod, produceAnnotion, consumeAnnotion, httpAnnotation, resourcePath, method, (ExecutableType)methodMirror, controller, boxedPrimitives);
            return Collections.singletonList(restMethod);
        }
        return Collections.emptyList();
    }

    private void configureMethod(Method restMethod, AnnotationMirror produceAnnotion, AnnotationMirror consumeAnnotion, AnnotationMirror httpAnnotation, String path, ExecutableElement methodElement, ExecutableType method, CompilationController controller, Collection<TypeMirror> boxedPrimitives) {
        List<String> mimes;
        String fqn = ((TypeElement)httpAnnotation.getAnnotationType().asElement()).getQualifiedName().toString();
        if ("javax.ws.rs.GET".equals(fqn) || "jakarta.ws.rs.GET".equals(fqn)) {
            mimes = this.getAnnotationMimes(produceAnnotion);
            if (mimes != null) {
                restMethod.setResponseMimes(mimes);
            }
        } else {
            mimes = this.getAnnotationMimes(produceAnnotion);
            if (mimes != null) {
                restMethod.setResponseMimes(mimes);
            }
            if ((mimes = this.getAnnotationMimes(consumeAnnotion)) != null) {
                restMethod.setRequestMimes(mimes);
            }
        }
        restMethod.setPath(path);
        TypeMirror returnTypeMirror = method.getReturnType();
        RestEntity returnEntity = this.getRestEntity(controller, boxedPrimitives, returnTypeMirror);
        restMethod.setReturnType(returnEntity);
        RestEntity paramEntity = this.getParamEntity(controller, boxedPrimitives, methodElement, method);
        restMethod.setParamType(paramEntity);
        for (Constants.HttpMethodType type : Constants.HttpMethodType.values()) {
            String annotationTypeJakarta = type.getAnnotationType(true);
            String annotationTypeJavax = type.getAnnotationType(false);
            if (!annotationTypeJakarta.equals(fqn) && !annotationTypeJavax.equals(fqn)) continue;
            restMethod.setType(type);
            break;
        }
    }

    private RestEntity getParamEntity(CompilationController controller, Collection<TypeMirror> boxedPrimitives, ExecutableElement methodElement, ExecutableType method) {
        List<? extends VariableElement> parameters = methodElement.getParameters();
        int index = -1;
        int i = 0;
        for (VariableElement variableElement : parameters) {
            List<? extends AnnotationMirror> annotationMirrors = variableElement.getAnnotationMirrors();
            boolean isUriParam = false;
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                String fqn;
                DeclaredType annotationType = annotationMirror.getAnnotationType();
                Element annotationElement = annotationType.asElement();
                if (!(annotationElement instanceof TypeElement) || !(fqn = ((TypeElement)annotationElement).getQualifiedName().toString()).equals("jakarta.ws.rs.QueryParam") && !fqn.equals("javax.ws.rs.QueryParam") && !fqn.equals("jakarta.ws.rs.PathParam") && !fqn.equals("javax.ws.rs.PathParam")) continue;
                isUriParam = true;
                break;
            }
            if (!isUriParam) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return new RestEntity(true);
        }
        List<? extends TypeMirror> parameterTypes = method.getParameterTypes();
        TypeMirror typeMirror = parameterTypes.get(index);
        return this.getRestEntity(controller, boxedPrimitives, typeMirror);
    }

    private RestEntity getRestEntity(CompilationController controller, Collection<TypeMirror> boxedPrimitives, TypeMirror typeMirror) {
        if (typeMirror.getKind() == TypeKind.VOID) {
            return new RestEntity(true);
        }
        String entityFqn = null;
        boolean isCollection = false;
        boolean isPrimitive = false;
        if (controller.getTypes().isSubtype(controller.getTypes().erasure(typeMirror), controller.getTypes().erasure(controller.getElements().getTypeElement(Collection.class.getCanonicalName()).asType()))) {
            isCollection = true;
            List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
            if (typeArguments.size() != 0) {
                TypeMirror typeArg = typeArguments.get(0);
                entityFqn = this.getQualifiedName(controller, typeArg);
            }
        } else if (typeMirror.getKind() == TypeKind.ARRAY) {
            isCollection = true;
            TypeMirror componentType = ((ArrayType)typeMirror).getComponentType();
            entityFqn = this.getQualifiedName(controller, componentType);
        }
        if (typeMirror.getKind().isPrimitive() || controller.getTypes().isSameType(typeMirror, controller.getElements().getTypeElement(String.class.getCanonicalName()).asType())) {
            isPrimitive = true;
        } else {
            for (TypeMirror boxed : boxedPrimitives) {
                if (!controller.getTypes().isSameType(typeMirror, boxed)) continue;
                isPrimitive = true;
                break;
            }
        }
        if (!isCollection && !isPrimitive) {
            entityFqn = this.getQualifiedName(controller, typeMirror);
        }
        if (entityFqn == null) {
            entityFqn = Object.class.getCanonicalName();
        }
        if (isPrimitive) {
            return new RestEntity(false);
        }
        return new RestEntity(entityFqn, isCollection);
    }

    private String getQualifiedName(CompilationController controller, TypeMirror typeMirror) {
        Element parameterElement;
        String entityFqn = null;
        if (typeMirror instanceof DeclaredType && (parameterElement = controller.getTypes().asElement(typeMirror)) instanceof TypeElement) {
            entityFqn = ((TypeElement)parameterElement).getQualifiedName().toString();
        }
        return entityFqn;
    }

    private <T> T chooseNotNull(T ... choice) {
        for (T t : choice) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private boolean isRestAnnotation(String annotation) {
        return annotation.equals("jakarta.ws.rs.Path") || annotation.equals("javax.ws.rs.Path") || annotation.equals("jakarta.ws.rs.Produces") || annotation.equals("javax.ws.rs.Produces") || annotation.equals("jakarta.ws.rs.Consumes") || annotation.equals("javax.ws.rs.Consumes") || annotation.equals("jakarta.ws.rs.GET") || annotation.equals("javax.ws.rs.GET") || annotation.equals("jakarta.ws.rs.POST") || annotation.equals("javax.ws.rs.POST") || annotation.equals("jakarta.ws.rs.PUT") || annotation.equals("javax.ws.rs.PUT") || annotation.equals("jakarta.ws.rs.DELETE") || annotation.equals("javax.ws.rs.DELETE");
    }

    private List<String> getAnnotationMimes(AnnotationMirror mirror) {
        if (mirror == null) {
            return null;
        }
        String mimes = RestUtils.getValueFromAnnotation(mirror);
        String[] mimeTypes = mimes.split(",");
        ArrayList<String> result = new ArrayList<String>(mimeTypes.length);
        for (String mime : mimeTypes) {
            if ((mime = mime.trim()).startsWith("\"")) {
                mime = mime.substring(1);
            }
            if (mime.endsWith("\"")) {
                mime = mime.substring(0, mime.length() - 1);
            }
            result.add(mime);
        }
        return result;
    }

    private Method createMethod(String mName, TypeElement clazz, CompilationController controller) {
        Method method = new Method(mName);
        List<? extends AnnotationMirror> annotationMirrors = controller.getElements().getAllAnnotationMirrors(clazz);
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            List<String> mimes;
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement)) continue;
            TypeElement annotation = (TypeElement)annotationElement;
            String name = annotation.getQualifiedName().toString();
            if ("jakarta.ws.rs.Produces".equals(name) || "javax.ws.rs.Produces".equals(name)) {
                mimes = this.getAnnotationMimes(annotationMirror);
                method.setResponseMimes(mimes);
                continue;
            }
            if (!"jakarta.ws.rs.Consumes".equals(name) && !"javax.ws.rs.Consumes".equals(name)) continue;
            mimes = this.getAnnotationMimes(annotationMirror);
            method.setRequestMimes(mimes);
        }
        return method;
    }
}

