/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.Image;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.design.view.DesignView;
import org.netbeans.modules.websvc.design.view.DesignViewPopupProvider;
import org.netbeans.modules.websvc.design.view.Flushable;
import org.netbeans.modules.websvc.design.view.actions.GotoSourceAction;
import org.netbeans.modules.websvc.design.view.actions.RemoveOperationAction;
import org.netbeans.modules.websvc.design.view.widget.AbstractTitledWidget;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.DescriptionWidget;
import org.netbeans.modules.websvc.design.view.widget.FaultsWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.netbeans.modules.websvc.design.view.widget.OutputWidget;
import org.netbeans.modules.websvc.design.view.widget.ParametersWidget;
import org.netbeans.modules.websvc.design.view.widget.SampleMessageWidget;
import org.netbeans.modules.websvc.design.view.widget.TabbedPaneWidget;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class OperationWidget
extends AbstractTitledWidget
implements Flushable {
    private static final String IMAGE_ONE_WAY = "org/netbeans/modules/websvc/design/view/resources/oneway_operation.png";
    private static final String IMAGE_REQUEST_RESPONSE = "org/netbeans/modules/websvc/design/view/resources/requestresponse_operation.png";
    private static final String IMAGE_NOTIFICATION = "org/netbeans/modules/websvc/design/view/resources/notification_operation.png";
    private ProjectService service;
    private MethodModel operation;
    private ServiceModel serviceModel;
    private transient Widget buttons;
    private transient ImageLabelWidget headerLabelWidget;
    private transient TabbedPaneWidget tabbedWidget;
    private transient Widget listWidget;
    private transient ButtonWidget viewButton;
    private transient RemoveOperationAction removeAction;
    private ParametersWidget inputWidget;
    private OutputWidget outputWidget;
    private FaultsWidget faultWidget;
    private DescriptionWidget descriptionWidget;

    public OperationWidget(ObjectScene scene, ServiceModel serviceModel, ProjectService service, MethodModel operation) {
        super(scene, 12, 12, 6, BORDER_COLOR);
        this.service = service;
        this.operation = operation;
        this.serviceModel = serviceModel;
        this.removeAction = new RemoveOperationAction(service);
        this.removeAction.setWorkingSet(Collections.singleton(operation));
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)new DesignViewPopupProvider(new Action[]{new GotoSourceAction(operation, serviceModel.getImplementationClass()), this.removeAction})));
        this.createContent();
    }

    public MethodModel getMethodModel() {
        return this.operation;
    }

    @Override
    public void flushContent() {
        if (this.descriptionWidget != null) {
            this.descriptionWidget.flushContent();
        }
    }

    private void createContent() {
        String typeOfOperation = "";
        Image image = null;
        if (this.operation.isOneWay()) {
            typeOfOperation = NbBundle.getMessage(OperationWidget.class, (String)"LBL_OneWay");
            image = ImageUtilities.loadImage((String)IMAGE_ONE_WAY);
        } else if (!this.operation.getParams().isEmpty()) {
            typeOfOperation = NbBundle.getMessage(OperationWidget.class, (String)"LBL_RequestResponse");
            image = ImageUtilities.loadImage((String)IMAGE_REQUEST_RESPONSE);
        } else {
            typeOfOperation = NbBundle.getMessage(OperationWidget.class, (String)"LBL_Notification");
            image = ImageUtilities.loadImage((String)IMAGE_NOTIFICATION);
        }
        this.headerLabelWidget = new ImageLabelWidget(this.getScene(), image, this.operation.getOperationName()){
            private Object key;
            {
                this.key = new Object();
            }

            protected void notifyAdded() {
                super.notifyAdded();
                OperationWidget.this.getObjectScene().addObject(this.key, new Widget[]{OperationWidget.this.headerLabelWidget});
            }

            protected void notifyRemoved() {
                super.notifyRemoved();
                OperationWidget.this.getObjectScene().removeObject(this.key);
            }
        };
        this.headerLabelWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
        this.headerLabelWidget.setLabelEditor(new TextFieldInplaceEditor(){

            public boolean isEnabled(Widget widget) {
                return OperationWidget.this.isNameEditable();
            }

            public String getText(Widget widget) {
                return OperationWidget.this.headerLabelWidget.getLabel();
            }

            public void setText(Widget widget, String text) {
                OperationWidget.this.operation.setOperationName(text);
                OperationWidget.this.headerLabelWidget.setLabel(text);
            }
        });
        this.headerLabelWidget.setToolTipText(typeOfOperation);
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)8));
        this.viewButton = new ButtonWidget(this.getScene(), null, null);
        this.viewButton.setImage(new TabImageWidget(this.getScene(), 16));
        this.viewButton.setSelectedImage((Object)new ListImageWidget(this.getScene(), 16));
        this.viewButton.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OperationWidget.this.setTabbedView(!OperationWidget.this.viewButton.isSelected());
            }
        });
        this.buttons.addChild((Widget)this.viewButton);
        for (final SampleMessageWidget.Type type : SampleMessageWidget.Type.values()) {
            final ButtonWidget sampleButton = new ButtonWidget(this.getScene(), null, null);
            sampleButton.setImage(type.getIcon(this.getScene()));
            sampleButton.setAction(new AbstractAction(){
                SampleMessageWidget messageWidget;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Widget messageLayer = OperationWidget.this.getObjectScene().findWidget(DesignView.messageLayerKey);
                    if (this.messageWidget != null && messageLayer.getChildren().contains(this.messageWidget)) {
                        messageLayer.removeChild((Widget)this.messageWidget);
                        this.messageWidget = null;
                    } else {
                        messageLayer.removeChildren();
                        this.messageWidget = new SampleMessageWidget(OperationWidget.this.getObjectScene(), OperationWidget.this.operation, type){

                            @Override
                            protected void notifyAdded() {
                                super.notifyAdded();
                                sampleButton.setOpaque(true);
                                sampleButton.setSelected(true);
                            }

                            @Override
                            protected void notifyRemoved() {
                                super.notifyRemoved();
                                sampleButton.setOpaque(false);
                                sampleButton.setSelected(false);
                            }
                        };
                        messageLayer.addChild((Widget)this.messageWidget);
                    }
                }
            });
            sampleButton.setToolTipText(type.getDescription());
            this.buttons.addChild((Widget)sampleButton);
        }
        this.buttons.addChild((Widget)this.getExpanderWidget());
        this.getHeaderWidget().addChild(this.buttons);
        this.listWidget = new Widget(this.getScene());
        this.listWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)6));
        this.inputWidget = new ParametersWidget(this.getObjectScene(), this.operation, this.isNameEditable());
        this.outputWidget = new OutputWidget(this.getObjectScene(), this.operation);
        this.faultWidget = new FaultsWidget(this.getObjectScene(), this.operation);
        this.descriptionWidget = new DescriptionWidget(this.getObjectScene(), this.operation);
        this.listWidget.addChild((Widget)this.inputWidget);
        this.listWidget.addChild((Widget)this.outputWidget);
        this.listWidget.addChild((Widget)this.faultWidget);
        this.listWidget.addChild((Widget)this.descriptionWidget);
        this.tabbedWidget = new TabbedPaneWidget(this.getScene());
        this.tabbedWidget.addTab(this.inputWidget);
        this.tabbedWidget.addTab(this.outputWidget);
        this.tabbedWidget.addTab(this.faultWidget);
        this.tabbedWidget.addTab(this.descriptionWidget);
        this.setTabbedView(!this.viewButton.isSelected());
    }

    @Override
    protected void collapseWidget() {
        if (this.buttons != null && this.buttons.getParentWidget() != null) {
            this.getHeaderWidget().revalidate(true);
            this.buttons.removeChild((Widget)this.getExpanderWidget());
            this.getHeaderWidget().removeChild(this.buttons);
            this.getHeaderWidget().addChild((Widget)this.getExpanderWidget());
        }
        super.collapseWidget();
        if (this.hashKey() != null) {
            this.getObjectScene().setSelectedObjects(Collections.singleton(this.hashKey()));
            this.getObjectScene().setFocusedObject(this.hashKey());
        }
    }

    @Override
    protected void expandWidget() {
        if (this.buttons != null && this.buttons.getParentWidget() == null) {
            this.getHeaderWidget().revalidate(true);
            this.getHeaderWidget().removeChild((Widget)this.getExpanderWidget());
            this.buttons.addChild((Widget)this.getExpanderWidget());
            this.getHeaderWidget().addChild(this.buttons);
        }
        super.expandWidget();
        if (this.hashKey() != null) {
            this.getObjectScene().setSelectedObjects(Collections.singleton(this.hashKey()));
            this.getObjectScene().setFocusedObject(this.hashKey());
        }
    }

    @Override
    public Object hashKey() {
        return this.operation;
    }

    private void setTabbedView(boolean tabbedView) {
        if (this.viewButton.isSelected() != tabbedView) {
            this.viewButton.setSelected(tabbedView);
            if (tabbedView) {
                if (this.listWidget.getParentWidget() == this.getContentWidget()) {
                    this.getContentWidget().removeChild(this.listWidget);
                }
                this.getContentWidget().addChild((Widget)this.tabbedWidget);
            } else {
                if (this.tabbedWidget.getParentWidget() == this.getContentWidget()) {
                    this.getContentWidget().removeChild((Widget)this.tabbedWidget);
                }
                this.getContentWidget().addChild(this.listWidget);
            }
        }
    }

    private boolean isNameEditable() {
        return this.service != null && this.service.getWsdlUrl() == null;
    }

    private static class TabImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        public TabImageWidget(Scene scene, int size) {
            super(scene, Color.LIGHT_GRAY, size, size);
            this.setBorder(BorderFactory.createLineBorder((int)0, (Color)Color.LIGHT_GRAY));
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.setToolTipText(NbBundle.getMessage(OperationWidget.class, (String)"Hint_TabbedView"));
        }

        @Override
        protected Shape createImage(int width, int height) {
            GeneralPath path = new GeneralPath();
            path.moveTo(1.0f, (float)height / 6.0f);
            path.lineTo((float)(2 * width) / 3.0f, (float)height / 6.0f);
            path.moveTo(1.0f, (float)height / 3.0f + 1.0f);
            path.lineTo(width - 1, (float)height / 3.0f + 1.0f);
            path.moveTo((float)width / 3.0f, (float)height / 6.0f + 1.0f);
            path.lineTo((float)width / 3.0f, (float)height / 3.0f);
            path.moveTo((float)(2 * width) / 3.0f, (float)height / 6.0f + 1.0f);
            path.lineTo((float)(2 * width) / 3.0f, (float)height / 3.0f);
            return path;
        }
    }

    private static class ListImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        public ListImageWidget(Scene scene, int size) {
            super(scene, Color.LIGHT_GRAY, size, size);
            this.setBorder(BorderFactory.createLineBorder((int)0, (Color)Color.LIGHT_GRAY));
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
            this.setToolTipText(NbBundle.getMessage(OperationWidget.class, (String)"Hint_ListView"));
        }

        @Override
        protected Shape createImage(int width, int height) {
            GeneralPath path = new GeneralPath();
            float gap = (float)width / 5.0f;
            path.moveTo(gap, height / 4);
            path.lineTo((float)width - gap, height / 4);
            path.moveTo(gap, height / 2);
            path.lineTo((float)width - gap, height / 2);
            path.moveTo(gap, 3 * height / 4);
            path.lineTo((float)width - 2.0f * gap, 3 * height / 4);
            return path;
        }
    }
}

