/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websocket.wizard;

import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websocket.wizard.WebSocketVisual;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class WebSocketPanel
implements WizardDescriptor.Panel<WizardDescriptor> {
    static final String URI = "websocket.uri";
    private WebSocketVisual myComponent;
    private WizardDescriptor myDescriptor;

    WebSocketPanel(WizardDescriptor wizard) {
        this.myDescriptor = wizard;
    }

    public void addChangeListener(ChangeListener listener) {
        this.getComponent().addChangeListener(listener);
    }

    public WebSocketVisual getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new WebSocketVisual(this.myDescriptor);
        }
        return this.myComponent;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.websocket.wizard.WebSocketPanel");
    }

    public boolean isValid() {
        Profile profile;
        Project project = Templates.getProject((WizardDescriptor)this.myDescriptor);
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null && (profile = webModule.getJ2eeProfile()) != null && profile.isAtMost(Profile.JAVA_EE_6_FULL)) {
            this.setErrorMessage(NbBundle.getMessage(WebSocketPanel.class, (String)"MSG_NoJEE7Profile"));
            return false;
        }
        String msg = this.getComponent().getError();
        this.setErrorMessage(msg);
        return msg == null;
    }

    public void readSettings(WizardDescriptor descriptor) {
        this.getComponent().readSettings(descriptor);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getComponent().removeChangeListener(listener);
    }

    public void storeSettings(WizardDescriptor descriptor) {
        this.getComponent().storeSettings(descriptor);
    }

    private void setErrorMessage(String message) {
        this.myDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
    }
}

