/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.PositionRef;

public final class Modifications {
    Map<FileObject, List<Difference>> diffs = new HashMap<FileObject, List<Difference>>();

    public void addDifference(FileObject fileObject, Difference difference) {
        List<Difference> differences = this.diffs.get(fileObject);
        if (differences == null) {
            differences = new ArrayList<Difference>();
            differences.add(difference);
            this.diffs.put(fileObject, differences);
        } else {
            differences.add(difference);
        }
    }

    public void commit() throws IOException {
        for (Map.Entry<FileObject, List<Difference>> me : this.diffs.entrySet()) {
            this.commit(me.getKey(), me.getValue(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(FileObject fileObject, final List<Difference> differences, Writer outWriter) throws IOException {
        StyledDocument doc;
        EditorCookie editorCookie;
        DataObject dataObj = DataObject.find((FileObject)fileObject);
        EditorCookie editorCookie2 = editorCookie = dataObj != null ? (EditorCookie)dataObj.getCookie(EditorCookie.class) : null;
        if (editorCookie != null && outWriter == null && (doc = editorCookie.getDocument()) != null) {
            final BadLocationException[] blex = new BadLocationException[1];
            if (doc instanceof BaseDocument) {
                ((BaseDocument)doc).runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        for (Difference diff : differences) {
                            if (diff.isExcluded()) continue;
                            try {
                                switch (diff.getKind()) {
                                    case INSERT: {
                                        doc.insertString(diff.getStartPosition().getOffset(), diff.getNewText(), null);
                                        break;
                                    }
                                    case REMOVE: {
                                        doc.remove(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset());
                                        break;
                                    }
                                    case CHANGE: {
                                        doc.remove(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset());
                                        doc.insertString(diff.getStartPosition().getOffset(), diff.getNewText(), null);
                                    }
                                }
                            }
                            catch (BadLocationException ex) {
                                blex[0] = ex;
                            }
                        }
                    }
                });
            }
            if (blex[0] != null) {
                throw new IOException(blex[0]);
            }
            return;
        }
        InputStream ins = null;
        ByteArrayOutputStream baos = null;
        Reader inputReader = null;
        try {
            int count;
            Charset encoding = FileEncodingQuery.getEncoding((FileObject)fileObject);
            ins = fileObject.getInputStream();
            baos = new ByteArrayOutputStream();
            FileUtil.copy((InputStream)ins, (OutputStream)baos);
            ins.close();
            ins = null;
            byte[] arr = baos.toByteArray();
            int arrLength = this.convertToLF(arr);
            baos.close();
            baos = null;
            inputReader = new InputStreamReader((InputStream)new ByteArrayInputStream(arr, 0, arrLength), encoding);
            if (outWriter == null) {
                outWriter = new OutputStreamWriter(fileObject.getOutputStream(), encoding);
            }
            int offset = 0;
            Difference[] aDifferences = differences.toArray(new Difference[0]);
            Arrays.sort(aDifferences, new Comparator<Difference>(){

                @Override
                public int compare(Difference diff1, Difference diff2) {
                    int result = 0;
                    if (diff1.getStartPosition().getOffset() < diff2.getStartPosition().getOffset()) {
                        result = -1;
                    } else if (diff1.getStartPosition().getOffset() > diff2.getStartPosition().getOffset()) {
                        result = 1;
                    }
                    return result;
                }
            });
            block8: for (Difference diff : aDifferences) {
                int length;
                int pos;
                if (diff.isExcluded() || (pos = diff.getStartPosition().getOffset()) < offset) continue;
                int toread = pos - offset;
                char[] buff = new char[toread];
                int rcounter = 0;
                while ((length = inputReader.read(buff, 0, toread - rcounter)) > 0 && rcounter < toread) {
                    outWriter.write(buff, 0, length);
                    rcounter += length;
                    offset += length;
                }
                switch (diff.getKind()) {
                    case INSERT: {
                        outWriter.write(diff.getNewText());
                        continue block8;
                    }
                    case REMOVE: {
                        int len = diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset();
                        inputReader.skip(len);
                        offset += len;
                        continue block8;
                    }
                    case CHANGE: {
                        int len = diff.getEndPosition().getOffset() - diff.getStartPosition().getOffset();
                        inputReader.skip(len);
                        offset += len;
                        outWriter.write(diff.getNewText());
                    }
                }
            }
            char[] buff = new char[1024];
            while ((count = inputReader.read(buff)) > 0) {
                outWriter.write(buff, 0, count);
            }
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (baos != null) {
                baos.close();
            }
            if (inputReader != null) {
                inputReader.close();
            }
            if (outWriter != null) {
                outWriter.close();
            }
        }
    }

    private int convertToLF(byte[] buff) {
        int index = 0;
        for (int i = 0; i < buff.length; ++i) {
            if (buff[i] == 13) continue;
            buff[index++] = buff[i];
        }
        return index;
    }

    public String getResultingSource(FileObject fileObject) throws IOException {
        assert (fileObject != null) : "Provided fileObject is null";
        StringWriter writer = new StringWriter();
        this.commit(fileObject, this.diffs.get(fileObject), writer);
        return writer.toString();
    }

    public static final class Difference {
        Kind kind;
        PositionRef startPos;
        PositionRef endPos;
        String oldText;
        String newText;
        String description;
        private boolean excluded;

        Difference(Kind kind, PositionRef startPos, PositionRef endPos, String oldText, String newText, String description) {
            this.kind = kind;
            this.startPos = startPos;
            this.endPos = endPos;
            this.oldText = oldText;
            this.newText = newText;
            this.excluded = false;
            this.description = description;
        }

        public Kind getKind() {
            return this.kind;
        }

        public String getDesription() {
            return this.description;
        }

        public PositionRef getStartPosition() {
            return this.startPos;
        }

        public PositionRef getEndPosition() {
            return this.endPos;
        }

        public String getOldText() {
            return this.oldText;
        }

        public String getNewText() {
            return this.newText;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExclude(boolean exclude) {
            this.excluded = exclude;
        }

        public String toString() {
            return (Object)((Object)this.kind) + "<" + this.startPos.getOffset() + ", " + this.endPos.getOffset() + ">: " + this.oldText + " -> " + this.newText;
        }

        public static enum Kind {
            INSERT,
            REMOVE,
            CHANGE;

        }
    }
}

