/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.jsf.wizards.Bundle;
import org.netbeans.modules.web.jsf.wizards.ResourceLibraryIterator;
import org.netbeans.modules.web.jsf.wizards.ResourceLibraryIteratorPanelVisual;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;

public class ResourceLibraryIteratorPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private static final Pattern FOLDER_NAME_EXCLUDES = Pattern.compile(".*[!@%^&(){}/\\`?*<>|\":]+.*");
    protected static final String PROP_CONTRACT_NAME = "contractName";
    protected static final String PROP_TEMPLATE_NAME = "templateName";
    protected static final String PROP_CREATE_TEMPLATE = "createTemplate";
    protected static final String PROP_TEMPLATE_PANEL = "templatePanel";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final WizardDescriptor descriptor;
    private final Project project;
    private final FileObject contractsParent;
    private final ResourceLibraryIterator.ProjectType projectType;
    private ResourceLibraryIteratorPanelVisual gui;

    ResourceLibraryIteratorPanel(WizardDescriptor descriptor, FileObject contractsParent, ResourceLibraryIterator.ProjectType projectType) {
        this.descriptor = descriptor;
        this.contractsParent = contractsParent;
        this.projectType = projectType;
        this.project = Templates.getProject((WizardDescriptor)descriptor);
    }

    public synchronized ResourceLibraryIteratorPanelVisual getComponent() {
        if (this.gui == null) {
            this.gui = new ResourceLibraryIteratorPanelVisual(this.project, this.contractsParent, this.projectType);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void readSettings(WizardDescriptor settings) {
        this.getComponent();
        this.gui.addChangeListener(this);
    }

    public void storeSettings(WizardDescriptor settings) {
        this.getComponent();
        this.gui.removeChangeListener(this);
        settings.putProperty(PROP_CONTRACT_NAME, (Object)this.gui.getContractName());
        settings.putProperty(PROP_CREATE_TEMPLATE, (Object)this.gui.isCreateInitialTemplate());
        settings.putProperty(PROP_TEMPLATE_NAME, (Object)this.gui.getTemplateName());
        settings.putProperty(PROP_TEMPLATE_PANEL, (Object)this.gui.getTemplatePanel());
    }

    public boolean isValid() {
        this.getComponent();
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        if (!this.contractsParent.isValid() || !this.contractsParent.isFolder()) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.ResourceLibraryIteratorPanel_err_contracts_parent_not_extists());
            return false;
        }
        FileObject contractsFolder = this.contractsParent.getFileObject("contracts");
        if (contractsFolder == null) {
            if (!this.contractsParent.canWrite()) {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.ResourceLibraryIteratorPanel_err_contracts_parent_not_writeable());
                return false;
            }
        } else {
            if (!contractsFolder.canWrite()) {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.ResourceLibraryIteratorPanel_err_contracts_folder_not_writeable());
                return false;
            }
            if (contractsFolder.getFileObject(this.gui.getContractName()) != null) {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.ResourceLibraryIteratorPanel_err_contract_already_exists());
                return false;
            }
        }
        if (this.gui.getContractName().isEmpty()) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.ResourceLibraryIteratorPanel_err_contract_name_empty());
            return false;
        }
        if (!ResourceLibraryIteratorPanel.isValidFileName(this.gui.getContractName())) {
            this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.ResourceLibraryIteratorPanel_err_contract_name_not_valid());
            return false;
        }
        if (this.gui.isCreateInitialTemplate()) {
            if (this.gui.getTemplateName().isEmpty()) {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.ResourceLibraryIteratorPanel_err_template_name_empty());
                return false;
            }
            if (!ResourceLibraryIteratorPanel.isValidFileName(this.gui.getTemplateName())) {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)Bundle.ResourceLibraryIteratorPanel_err_template_name_not_valid());
                return false;
            }
        }
        return true;
    }

    private static boolean isValidFileName(String name) {
        Matcher matcher = FOLDER_NAME_EXCLUDES.matcher(name);
        return !matcher.matches();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        this.changeSupport.fireChange();
    }
}

