/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.knockout.unused;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.inspect.files.Files;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.knockout.unused.Bundle;
import org.netbeans.modules.web.inspect.webkit.knockout.unused.UnusedBinding;
import org.netbeans.modules.web.inspect.webkit.knockout.unused.UnusedRootNode;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.api.page.Page;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UnusedBindingsPanel
extends JPanel
implements ExplorerManager.Provider {
    private static final RequestProcessor RP = new RequestProcessor(UnusedBindingsPanel.class);
    private WebKitPageModel pageModel;
    private final ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private final UnusedRootNode rootNode = new UnusedRootNode(Collections.emptyMap());
    private JPanel dataPanel;
    private JButton findButton;
    private JLabel findLabel;
    private JPanel findPanel;
    private JLabel messageLabel;
    private JButton refreshButton;
    private JPanel refreshPanel;

    public UnusedBindingsPanel() {
        this.initTreeView();
        this.initComponents();
        this.add(this.findPanel);
        this.manager.setRootContext((Node)this.rootNode);
        this.dataPanel.add((Component)this.treeView);
    }

    private void initTreeView() {
        this.treeView = new BeanTreeView();
        this.treeView.setAllowedDragActions(0);
        this.treeView.setAllowedDropActions(0);
        this.treeView.setRootVisible(false);
    }

    public void setPageModel(WebKitPageModel pageModel) {
        this.pageModel = pageModel;
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void preparePage() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Page page = UnusedBindingsPanel.this.pageModel.getWebKit().getPage();
                String prefix = Files.getScript("knockout-pre");
                prefix = prefix.replace("\"", "\\\"");
                prefix = UnusedBindingsPanel.this.toOneLiner(prefix);
                String suffix = Files.getScript("knockout-post");
                suffix = suffix.replace("\"", "\\\"");
                suffix = suffix.replace("\n", "\\n");
                String preprocessor = "(function (script) {\n  var prefix = \"" + prefix + "\";\n  var suffix = \"" + suffix + "\";\n  var newScript;\n  if (script.indexOf('getBindingAccessors') != -1 && script.indexOf('bindingProvider') != -1) {\n    newScript = prefix + script + suffix;\n  } else {\n    newScript = script;\n  }\n  return newScript;\n})";
                page.reload(false, null, preprocessor);
            }
        });
    }

    private String toOneLiner(String jsCode) {
        StringBuilder result = new StringBuilder(jsCode.length());
        for (String line : jsCode.split("\n")) {
            int index = line.indexOf("//");
            String lineWithoutComment = index == -1 ? line : line.substring(0, index);
            result.append(lineWithoutComment);
        }
        return result.toString();
    }

    public void setKnockoutVersion(String knockoutVersion) {
        if (knockoutVersion == null) {
            this.showComponent(this.findPanel);
        } else {
            BrowserFamilyId browser = (BrowserFamilyId)this.pageModel.getPageContext().lookup(BrowserFamilyId.class);
            if (this.isSupportedBrowser(browser)) {
                if (this.isSupportedKnockoutVersion(knockoutVersion)) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            boolean found;
                            RemoteObject remoteObject = UnusedBindingsPanel.this.pageModel.getWebKit().getRuntime().evaluate("window.NetBeans && NetBeans.unusedBindingsAvailable()");
                            boolean bl = found = remoteObject != null && "true".equals(remoteObject.getValueAsString());
                            if (found) {
                                UnusedBindingsPanel.this.updateData();
                            }
                        }
                    });
                } else {
                    this.messageLabel.setText(Bundle.UnusedBindingsPanel_unsupportedVersion(knockoutVersion));
                    this.showComponent(this.messageLabel);
                }
            } else {
                this.messageLabel.setText(Bundle.UnusedBindingsPanel_unsupportedBrowser());
                this.showComponent(this.messageLabel);
            }
        }
    }

    private boolean isSupportedBrowser(BrowserFamilyId browser) {
        return browser != null && (browser == BrowserFamilyId.CHROME || browser == BrowserFamilyId.CHROMIUM || browser == BrowserFamilyId.ANDROID);
    }

    private boolean isSupportedKnockoutVersion(String version) {
        return version != null && !version.startsWith("2.") && !version.startsWith("1.");
    }

    void showComponent(JComponent component) {
        if (component.getParent() != this) {
            this.removeAll();
            this.add(component);
            this.revalidate();
            this.repaint();
        }
    }

    void updateData() {
        Object componentToShow;
        RemoteObject remoteObject = this.pageModel.getWebKit().getRuntime().evaluate("NetBeans.unusedBindings()");
        String json = remoteObject.getValueAsString();
        Map<String, Map<Integer, UnusedBinding>> unusedBindings = this.parse(json);
        this.rootNode.update(unusedBindings);
        if (unusedBindings.isEmpty()) {
            this.messageLabel.setText(Bundle.UnusedBindingsPanel_noUnusedBindings());
            componentToShow = this.messageLabel;
        } else {
            componentToShow = this.treeView;
        }
        EventQueue.invokeLater(new Runnable((JComponent)componentToShow){
            final /* synthetic */ JComponent val$componentToShow;
            {
                this.val$componentToShow = jComponent;
            }

            @Override
            public void run() {
                UnusedBindingsPanel.this.dataPanel.remove((Component)(this.val$componentToShow == UnusedBindingsPanel.this.messageLabel ? UnusedBindingsPanel.this.treeView : UnusedBindingsPanel.this.messageLabel));
                UnusedBindingsPanel.this.dataPanel.add(this.val$componentToShow);
                UnusedBindingsPanel.this.showComponent(UnusedBindingsPanel.this.dataPanel);
                UnusedBindingsPanel.this.dataPanel.revalidate();
                UnusedBindingsPanel.this.dataPanel.repaint();
            }
        });
    }

    private Map<String, Map<Integer, UnusedBinding>> parse(String json) {
        HashMap<String, Map<Integer, UnusedBinding>> map = new HashMap<String, Map<Integer, UnusedBinding>>();
        try {
            JSONArray array = (JSONArray)new JSONParser().parse(json);
            for (Object o : array) {
                JSONObject jsonBinding = (JSONObject)o;
                String name = (String)jsonBinding.get((Object)"name");
                if (this.ignoreUnusedBinding(name)) continue;
                int id = ((Number)jsonBinding.get((Object)"id")).intValue();
                UnusedBinding binding = new UnusedBinding(id, name, (String)jsonBinding.get((Object)"nodeTagName"), (String)jsonBinding.get((Object)"nodeId"), (String)jsonBinding.get((Object)"nodeClasses"), (Boolean)jsonBinding.get((Object)"nodeRemoved"), this.pageModel);
                HashMap<Integer, UnusedBinding> innerMap = (HashMap<Integer, UnusedBinding>)map.get(name);
                if (innerMap == null) {
                    innerMap = new HashMap<Integer, UnusedBinding>();
                    map.put(name, innerMap);
                }
                innerMap.put(id, binding);
            }
        }
        catch (ParseException pex) {
            Logger.getLogger(UnusedBindingsPanel.class.getName()).log(Level.INFO, null, pex);
        }
        return map;
    }

    private boolean ignoreUnusedBinding(String name) {
        return name.startsWith("_ko_");
    }

    private void initComponents() {
        this.findPanel = new JPanel();
        this.findButton = new JButton();
        this.findLabel = new JLabel();
        this.dataPanel = new JPanel();
        this.refreshPanel = new JPanel();
        this.refreshButton = new JButton();
        this.messageLabel = new JLabel();
        this.findPanel.setBackground(this.treeView.getViewport().getView().getBackground());
        Mnemonics.setLocalizedText((AbstractButton)this.findButton, (String)NbBundle.getMessage(UnusedBindingsPanel.class, (String)"UnusedBindingsPanel.findButton.text"));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnusedBindingsPanel.this.findButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.findLabel, (String)NbBundle.getMessage(UnusedBindingsPanel.class, (String)"UnusedBindingsPanel.findLabel.text"));
        GroupLayout findPanelLayout = new GroupLayout(this.findPanel);
        this.findPanel.setLayout(findPanelLayout);
        findPanelLayout.setHorizontalGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(findPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.findButton).addComponent(this.findLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        findPanelLayout.setVerticalGroup(findPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(findPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.findButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.findLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.dataPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(UnusedBindingsPanel.class, (String)"UnusedBindingsPanel.refreshButton.text"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnusedBindingsPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        GroupLayout refreshPanelLayout = new GroupLayout(this.refreshPanel);
        this.refreshPanel.setLayout(refreshPanelLayout);
        refreshPanelLayout.setHorizontalGroup(refreshPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refreshPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.refreshButton).addContainerGap(-1, Short.MAX_VALUE)));
        refreshPanelLayout.setVerticalGroup(refreshPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(refreshPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.refreshButton).addContainerGap()));
        this.dataPanel.add((Component)this.refreshPanel, "Last");
        this.messageLabel.setBackground(this.treeView.getViewport().getView().getBackground());
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setEnabled(false);
        this.messageLabel.setOpaque(true);
        this.setLayout(new BorderLayout());
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        this.preparePage();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                UnusedBindingsPanel.this.updateData();
            }
        });
    }
}

