/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.sourcemap;

import java.io.File;
import java.util.List;
import org.netbeans.modules.web.common.sourcemap.Mapping;
import org.netbeans.modules.web.common.sourcemap.SourceMap;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslatorImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public interface SourceMapsTranslator {
    public static SourceMapsTranslator create() {
        return new SourceMapsTranslatorImpl();
    }

    public boolean registerTranslation(FileObject var1, String var2);

    public boolean registerTranslation(FileObject var1, SourceMap var2);

    public void unregisterTranslation(FileObject var1);

    public Location getSourceLocation(Location var1);

    public Location getSourceLocation(Location var1, String var2);

    public Location getCompiledLocation(Location var1);

    public List<FileObject> getSourceFiles(FileObject var1);

    public static final class Location {
        private FileObject file;
        private int line;
        private int column;
        private SourceMap sourceMap;
        private Mapping mapping;
        private FileObject parentFolder;

        public Location(FileObject file, int line, int column) {
            this.file = file;
            this.line = line;
            this.column = column;
        }

        Location(SourceMap sourceMap, Mapping mapping, FileObject parentFolder) {
            this.sourceMap = sourceMap;
            this.mapping = mapping;
            this.parentFolder = parentFolder;
            this.line = -1;
            this.column = -1;
        }

        static FileObject getSourceFile(String sourcePath, FileObject parentFolder) {
            File sourceFile = new File(sourcePath);
            FileObject fo = sourceFile.isAbsolute() ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)sourceFile)) : parentFolder.getFileObject(sourcePath);
            return fo;
        }

        public FileObject getFile() {
            if (this.file == null) {
                int sourceIndex = this.mapping.getSourceIndex();
                String sourcePath = this.sourceMap.getSourcePath(sourceIndex);
                this.file = Location.getSourceFile(sourcePath, this.parentFolder);
            }
            return this.file;
        }

        public int getLine() {
            if (this.line < 0) {
                this.line = this.mapping.getOriginalLine();
            }
            return this.line;
        }

        public int getColumn() {
            if (this.column < 0 && this.mapping != null) {
                this.column = this.mapping.getOriginalColumn();
            }
            return this.column;
        }

        public String getName() {
            if (this.sourceMap != null && this.mapping != null && this.mapping.getNameIndex() >= 0) {
                return this.sourceMap.getName(this.mapping.getNameIndex());
            }
            return null;
        }
    }
}

