/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.ui;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.gsf.codecoverage.api.CoverageActionFactory;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.api.BadgeIcon;
import org.netbeans.modules.web.clientproject.api.build.BuildTools;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProviders;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvider;
import org.netbeans.modules.web.clientproject.api.remotefiles.RemoteFilesNodeFactory;
import org.netbeans.modules.web.clientproject.env.Values;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserImplementation;
import org.netbeans.modules.web.clientproject.ui.Bundle;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.netbeans.spi.queries.VisibilityQueryChangeEvent;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.XMLUtil;

public class ClientSideProjectLogicalView
implements LogicalViewProvider {
    static final Logger LOGGER = Logger.getLogger(ClientSideProjectLogicalView.class.getName());
    static final RequestProcessor RP = new RequestProcessor(ClientSideProjectLogicalView.class.getName(), 2);
    private final ClientSideProject project;

    public ClientSideProjectLogicalView(ClientSideProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        return ClientSideProjectNode.createForProject(this.project);
    }

    public Node findPath(Node root, Object target) {
        FileObject fo;
        Project prj = (Project)root.getLookup().lookup(Project.class);
        if (prj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            fo = (FileObject)target;
        } else if (target instanceof DataObject) {
            fo = ((DataObject)target).getPrimaryFile();
        } else {
            return null;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (!prj.equals(owner)) {
            return null;
        }
        for (Node node : root.getChildren().getNodes(true)) {
            Node[] nodes;
            FileObject kid = (FileObject)node.getLookup().lookup(FileObject.class);
            if (kid == null) continue;
            if (kid == fo) {
                return node;
            }
            if (!FileUtil.isParentOf((FileObject)kid, (FileObject)fo)) continue;
            Node found = ClientSideProjectLogicalView.findNode(node, kid, fo);
            if (found == null) {
                return null;
            }
            if (this.hasObject(found, target)) {
                return found;
            }
            for (Node child : nodes = found.getParentNode().getChildren().getNodes(true)) {
                if (!child.getName().equals(fo.getName()) || !this.hasObject(child, fo)) continue;
                return child;
            }
        }
        return null;
    }

    @CheckForNull
    private static Node findNode(Node node, FileObject root, FileObject fo) {
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
        String[] path = relPath.split("/");
        path[path.length - 1] = fo.getName();
        Node found = ClientSideProjectLogicalView.findNode(node, path);
        if (found != null) {
            return found;
        }
        path[path.length - 1] = fo.getNameExt();
        return ClientSideProjectLogicalView.findNode(node, path);
    }

    private static Node findNode(Node start, String[] path) {
        Node found = null;
        try {
            found = NodeOp.findPath((Node)start, (String[])path);
        }
        catch (NodeNotFoundException nodeNotFoundException) {
            // empty catch block
        }
        return found;
    }

    private boolean hasObject(Node node, Object obj) {
        if (obj == null) {
            return false;
        }
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null) {
            return false;
        }
        if (obj instanceof DataObject) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            if (dataObject.equals(obj)) {
                return true;
            }
            return this.hasObject(node, ((DataObject)obj).getPrimaryFile());
        }
        if (obj instanceof FileObject) {
            return obj.equals(fileObject);
        }
        return false;
    }

    public static NodeFactory createRemoteFiles() {
        return RemoteFilesNodeFactory.createRemoteFilesNodeFactory();
    }

    public static NodeFactory createJsTestingProvidersNodes() {
        return JsTestingProviders.getDefault().createJsTestingProvidersNodeFactory();
    }

    private static final class ClientSideProjectNode
    extends AbstractNode
    implements ChangeListener,
    PropertyChangeListener {
        private static final String HTML5_BADGE_ICON = "org/netbeans/modules/web/clientproject/ui/resources/html5-badge.png";
        private static final String JS_LIBRARY_BADGE_ICON = "org/netbeans/modules/web/clientproject/ui/resources/js-library-badge.png";
        private static final String PLACEHOLDER_BADGE_ICON = "org/netbeans/modules/web/clientproject/ui/resources/placeholder-badge.png";
        private static final URL PLACEHOLDER_BADGE_URL = ClientSideProjectNode.class.getResource("org/netbeans/modules/web/clientproject/ui/resources/placeholder-badge.png");
        private static final String ICON_TOOLTIP = "<img src=\"%s\">&nbsp;%s";
        private final ClientSideProject project;
        private final ProjectInformation projectInfo;
        private final Values evaluator;
        private final ProjectProblemsProvider problemsProvider;

        private ClientSideProjectNode(ClientSideProject project) {
            super(NodeFactorySupport.createCompositeChildren((Project)project, (String)"Projects/org-netbeans-modules-web-clientproject/Nodes"), ClientSideProjectNode.createLookup(project));
            this.project = project;
            this.projectInfo = ProjectUtils.getInformation((Project)project);
            this.evaluator = project.getEvaluator();
            this.problemsProvider = (ProjectProblemsProvider)project.getLookup().lookup(ProjectProblemsProvider.class);
        }

        public static ClientSideProjectNode createForProject(ClientSideProject project) {
            ClientSideProjectNode rootNode = new ClientSideProjectNode(project);
            rootNode.addListeners();
            return rootNode;
        }

        private void addListeners() {
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.evaluator));
            this.projectInfo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.projectInfo));
            this.problemsProvider.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.problemsProvider));
        }

        private static Lookup createLookup(ClientSideProject project) {
            InstanceContent instanceContent = new InstanceContent();
            instanceContent.add((Object)project);
            instanceContent.add((Object)project, (InstanceContent.Convertor)new InstanceContent.Convertor<ClientSideProject, FileObject>(){

                public FileObject convert(ClientSideProject obj) {
                    return obj.getProjectDirectory();
                }

                public Class<? extends FileObject> type(ClientSideProject obj) {
                    return FileObject.class;
                }

                public String id(ClientSideProject obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                public String displayName(ClientSideProject obj) {
                    return obj.toString();
                }
            });
            instanceContent.add((Object)project, (InstanceContent.Convertor)new InstanceContent.Convertor<ClientSideProject, DataObject>(){

                public DataObject convert(ClientSideProject obj) {
                    try {
                        FileObject fo = obj.getProjectDirectory();
                        return fo == null ? null : DataObject.find((FileObject)fo);
                    }
                    catch (DataObjectNotFoundException ex) {
                        LOGGER.log(Level.WARNING, null, ex);
                        return null;
                    }
                }

                public Class<? extends DataObject> type(ClientSideProject obj) {
                    return DataObject.class;
                }

                public String id(ClientSideProject obj) {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? "" : fo.getPath();
                }

                public String displayName(ClientSideProject obj) {
                    return obj.toString();
                }
            });
            return new AbstractLookup((AbstractLookup.Content)instanceContent);
        }

        public Action[] getActions(boolean arg0) {
            LinkedList<Action> actions = new LinkedList<Action>(Arrays.asList(CommonProjectActions.forType((String)"org-netbeans-modules-web-clientproject")));
            this.addBuildActions(actions);
            this.addCodeCoverageAction(actions);
            return actions.toArray(new Action[0]);
        }

        public Image getIcon(int type) {
            return this.annotateImage(ImageUtilities.loadImage((String)"org/netbeans/modules/web/clientproject/ui/resources/html5-project.png"));
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        private Image annotateImage(Image image) {
            Image icon = image;
            boolean badged = false;
            for (PlatformProvider provider : this.project.getPlatformProviders()) {
                BadgeIcon badgeIcon = provider.getBadgeIcon();
                if (badgeIcon != null) {
                    icon = ImageUtilities.addToolTipToImage((Image)icon, (String)String.format(ICON_TOOLTIP, badgeIcon.getUrl(), provider.getDisplayName()));
                    if (badged) continue;
                    icon = ImageUtilities.mergeImages((Image)icon, (Image)badgeIcon.getImage(), (int)0, (int)0);
                    badged = true;
                    continue;
                }
                icon = ImageUtilities.addToolTipToImage((Image)icon, (String)String.format(ICON_TOOLTIP, PLACEHOLDER_BADGE_URL, provider.getDisplayName()));
            }
            if (!badged) {
                Image projectBadge = ImageUtilities.loadImage((String)(this.project.isJsLibrary() ? JS_LIBRARY_BADGE_ICON : HTML5_BADGE_ICON));
                icon = ImageUtilities.mergeImages((Image)icon, (Image)projectBadge, (int)0, (int)0);
            }
            return icon;
        }

        public String getName() {
            return this.projectInfo.getDisplayName();
        }

        public String getHtmlDisplayName() {
            String dispName = super.getDisplayName();
            try {
                dispName = XMLUtil.toElementContent((String)dispName);
            }
            catch (CharConversionException ex) {
                return dispName;
            }
            return ClientSideProjectUtilities.hasErrors(this.project) ? "<font color=\"#" + Integer.toHexString(ClientSideProjectUtilities.getErrorForeground().getRGB() & 0xFFFFFF) + "\">" + dispName + "</font>" : null;
        }

        public String getShortDescription() {
            String projectDirName = FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
            if (this.project.isJsLibrary()) {
                return Bundle.ClientSideProjectNode_library_description(projectDirName);
            }
            return Bundle.ClientSideProjectNode_project_description(projectDirName);
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    this.fireIconChange();
                    this.fireOpenedIconChange();
                    this.fireDisplayNameChange(null, null);
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    this.fireIconChange();
                    this.fireNameChange(null, null);
                    this.fireDisplayNameChange(null, null);
                }
            });
        }

        private void addBuildActions(List<Action> actions) {
            ClientProjectEnhancedBrowserImplementation cfg = this.project.getEnhancedBrowserImpl();
            if (cfg == null) {
                return;
            }
            ActionProvider actionProvider = cfg.getActionProvider();
            if (actionProvider == null) {
                return;
            }
            HashSet<String> supportedActions = new HashSet<String>(Arrays.asList(actionProvider.getSupportedActions()));
            boolean hasBuildTools = BuildTools.getDefault().hasBuildTools((Project)this.project);
            boolean buildSupported = hasBuildTools || supportedActions.contains("build");
            boolean rebuildSupported = hasBuildTools || supportedActions.contains("rebuild");
            boolean cleanSupported = hasBuildTools || supportedActions.contains("clean");
            int index = 1;
            if (buildSupported || rebuildSupported || cleanSupported) {
                actions.add(index++, null);
            }
            if (buildSupported) {
                actions.add(index++, (Action)FileUtil.getConfigObject((String)"Actions/Project/org-netbeans-modules-project-ui-BuildProject.instance", Action.class));
            }
            if (rebuildSupported) {
                actions.add(index++, (Action)FileUtil.getConfigObject((String)"Actions/Project/org-netbeans-modules-project-ui-RebuildProject.instance", Action.class));
            }
            if (cleanSupported) {
                actions.add(index++, (Action)FileUtil.getConfigObject((String)"Actions/Project/org-netbeans-modules-project-ui-CleanProject.instance", Action.class));
            }
        }

        private void addCodeCoverageAction(List<Action> actions) {
            JsTestingProvider jsTestingProvider = this.project.getJsTestingProvider(false);
            if (jsTestingProvider == null || !jsTestingProvider.isCoverageSupported((Project)this.project)) {
                return;
            }
            int secondSeparatorIndex = actions.size();
            int separatorCount = 0;
            for (int i = 0; i < actions.size(); ++i) {
                if (actions.get(i) == null) {
                    ++separatorCount;
                }
                if (separatorCount != 2) continue;
                secondSeparatorIndex = i;
                break;
            }
            actions.add(secondSeparatorIndex, CoverageActionFactory.createCollectorAction(null, null));
        }
    }

    private static final class FolderNode
    extends FilterNode {
        private final ClientSideProject project;

        FolderNode(ClientSideProject project, Node original) {
            super(original, (Children)new FolderFilterChildren(project, original), (Lookup)new ProxyLookup(new Lookup[]{original.getLookup()}));
            assert (original != null);
            assert (project != null);
            this.project = project;
        }

        public Image getIcon(int type) {
            return this.getIcon(type, false);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type, true);
        }

        private Image getIcon(int type, boolean opened) {
            Image originalIcon;
            FileObject folder = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
            assert (folder.isFolder()) : folder;
            Project owner = FileOwnerQuery.getOwner((FileObject)folder);
            if (owner != null && !owner.equals(this.project) && owner.getProjectDirectory().equals(folder)) {
                originalIcon = ImageUtilities.icon2Image((Icon)ProjectUtils.getInformation((Project)owner).getIcon());
                try {
                    HashSet clds = new HashSet();
                    Collections.addAll(clds, owner.getProjectDirectory().getChildren());
                    originalIcon = FileUIUtils.getImageDecorator((FileSystem)owner.getProjectDirectory().getFileSystem()).annotateIcon(originalIcon, type, clds);
                }
                catch (FileStateInvalidException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            } else {
                originalIcon = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            }
            return originalIcon;
        }
    }

    private static class FolderFilterChildren
    extends FilterNode.Children
    implements ChangeListener {
        private final Set<File> ignoreList = new WeakSet();
        private final ClientSideProject project;

        FolderFilterChildren(ClientSideProject project, Node n) {
            this(project, n, Collections.emptyList());
        }

        FolderFilterChildren(ClientSideProject project, Node n, List<File> ignoreList) {
            super(n);
            this.project = project;
            this.ignoreList.addAll(ignoreList);
        }

        protected void addNotify() {
            super.addNotify();
            VisibilityQuery.getDefault().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)VisibilityQuery.getDefault()));
        }

        protected Node[] createNodes(Node key) {
            FileObject fo = (FileObject)key.getLookup().lookup(FileObject.class);
            if (fo == null) {
                return super.createNodes(key);
            }
            File file = FileUtil.toFile((FileObject)fo);
            if (file == null) {
                LOGGER.log(Level.WARNING, "No file found for fileobject {0}", fo);
                return super.createNodes(key);
            }
            if (!VisibilityQuery.getDefault().isVisible(fo)) {
                return new Node[0];
            }
            if (this.ignoreList.contains(file)) {
                return new Node[0];
            }
            return super.createNodes(key);
        }

        protected Node copyNode(Node node) {
            FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
            if (fo == null) {
                return super.copyNode(node);
            }
            if (fo.isFolder()) {
                return new FolderNode(this.project, node);
            }
            return super.copyNode(node);
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            Node[] children = this.original.getChildren().getNodes();
            if (event instanceof VisibilityQueryChangeEvent) {
                HashSet<FileObject> fileObjects = new HashSet<FileObject>(Arrays.asList(((VisibilityQueryChangeEvent)event).getFileObjects()));
                for (Node child : children) {
                    if (!fileObjects.contains(child.getLookup().lookup(FileObject.class))) continue;
                    this.refreshNodes(new Node[]{child});
                }
                return;
            }
            this.refreshNodes(children);
        }

        private void refreshNodes(Node[] nodes) {
            for (Node node : nodes) {
                this.refreshKey(node);
            }
        }
    }

    private static final class FolderFilterNode
    extends FilterNode {
        private static final String SOURCES_FILES_BADGE = "org/netbeans/modules/web/clientproject/ui/resources/sources-badge.gif";
        private static final String SITE_ROOT_FILES_BADGE = "org/netbeans/modules/web/clientproject/ui/resources/siteroot-badge.gif";
        private final BasicNodes nodeType;
        private final Node delegate;

        public FolderFilterNode(ClientSideProject project, BasicNodes nodeType, Node folderNode, List<File> ignoreList) {
            super(folderNode, (Children)(folderNode.isLeaf() ? FilterNode.Children.LEAF : new FolderFilterChildren(project, folderNode, ignoreList)));
            this.nodeType = nodeType;
            this.delegate = folderNode;
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add((Action)SystemAction.get(FindAction.class));
            actions.add(null);
            actions.add((Action)SystemAction.get(FileSystemAction.class));
            actions.add(null);
            actions.add((Action)SystemAction.get(PasteAction.class));
            actions.add(null);
            actions.add((Action)SystemAction.get(ToolsAction.class));
            actions.add(null);
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[0]);
        }

        public boolean canRename() {
            return false;
        }

        public Image getIcon(int type) {
            return this.computeIcon(this.nodeType, false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(this.nodeType, true, type);
        }

        private Image computeIcon(BasicNodes node, boolean opened, int type) {
            Image image;
            String badge = null;
            switch (this.nodeType) {
                case Sources: 
                case Tests: 
                case TestsSelenium: {
                    badge = SOURCES_FILES_BADGE;
                    break;
                }
                case SiteRoot: 
                case SourcesAndSiteRoot: {
                    badge = SITE_ROOT_FILES_BADGE;
                    break;
                }
                default: {
                    assert (false) : "Unknown nodeType: " + (Object)((Object)this.nodeType);
                    break;
                }
            }
            Image image2 = image = opened ? this.delegate.getOpenedIcon(type) : this.delegate.getIcon(type);
            if (badge != null) {
                image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)badge, (boolean)false), (int)7, (int)7);
            }
            return image;
        }

        public String getDisplayName() {
            switch (this.nodeType) {
                case Sources: {
                    return ResourceBundle.getBundle("org/netbeans/modules/web/clientproject/ui/Bundle").getString("SOURCES");
                }
                case SiteRoot: {
                    return ResourceBundle.getBundle("org/netbeans/modules/web/clientproject/ui/Bundle").getString("SITE_ROOT");
                }
                case SourcesAndSiteRoot: {
                    return ResourceBundle.getBundle("org/netbeans/modules/web/clientproject/ui/Bundle").getString("SOURCES_SITE_ROOT");
                }
                case Tests: {
                    return ResourceBundle.getBundle("org/netbeans/modules/web/clientproject/ui/Bundle").getString("UNIT_TESTS");
                }
                case TestsSelenium: {
                    return ResourceBundle.getBundle("org/netbeans/modules/web/clientproject/ui/Bundle").getString("SELENIUM_TESTS");
                }
            }
            throw new AssertionError((Object)this.nodeType.name());
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.nodeType != null ? this.nodeType.hashCode() : 0);
            hash = 29 * hash + Objects.hashCode(this.delegate);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            FolderFilterNode other = (FolderFilterNode)((Object)obj);
            if (this.nodeType != other.nodeType) {
                return false;
            }
            return Objects.equals(this.delegate, other.delegate);
        }
    }

    private static class Key {
        private final BasicNodes node;
        private final FileObject root;

        public Key(BasicNodes node, FileObject root) {
            assert (node != null);
            assert (root != null);
            this.node = node;
            this.root = root;
        }

        public BasicNodes getNode() {
            return this.node;
        }

        public FileObject getRoot() {
            return this.root;
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + Objects.hashCode((Object)this.node);
            hash = 89 * hash + Objects.hashCode(this.root);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.node != other.node) {
                return false;
            }
            return Objects.equals(this.root, other.root);
        }
    }

    private static final class ClientProjectNodeList
    implements NodeList<Key>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final ClientSideProject project;
        private final FileObject nbprojectFolder;
        final Sources projectSources;
        final ChangeListener changeListener;

        private ClientProjectNodeList(ClientSideProject p) {
            this.project = p;
            this.nbprojectFolder = p.getProjectDirectory().getFileObject("nbproject");
            assert (this.nbprojectFolder != null) : "Folder nbproject must exist for project " + this.project.getName();
            this.projectSources = ProjectUtils.getSources((Project)p);
            this.changeListener = WeakListeners.change((ChangeListener)this, (Object)this.projectSources);
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public void addNotify() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    projectSources.addChangeListener(changeListener);
                }
            });
        }

        public void removeNotify() {
        }

        void fireChange() {
            this.changeSupport.fireChange();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.fireChange();
                }
            });
        }

        public Node node(Key key) {
            BasicNodes node = key.getNode();
            switch (node) {
                case Sources: 
                case SiteRoot: 
                case SourcesAndSiteRoot: 
                case Tests: 
                case TestsSelenium: {
                    return this.createNodeForFolder(key);
                }
            }
            assert (false) : "Unknown node type: " + (Object)((Object)node);
            return null;
        }

        private List<File> getIgnoredFiles(BasicNodes basicNodes) {
            ArrayList<File> ignoredFiles = new ArrayList<File>();
            FileObject buildFolder = this.project.getProjectDirectory().getFileObject("build");
            switch (basicNodes) {
                case Sources: 
                case SiteRoot: 
                case SourcesAndSiteRoot: 
                case Tests: 
                case TestsSelenium: {
                    this.addIgnoredFile(ignoredFiles, this.nbprojectFolder);
                    this.addIgnoredFile(ignoredFiles, buildFolder);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown BasicNodes: " + (Object)((Object)basicNodes));
                }
            }
            return ignoredFiles;
        }

        private void addIgnoredFile(List<File> ignoredFiles, FileObject fileObject) {
            if (fileObject == null) {
                return;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file != null) {
                ignoredFiles.add(file);
            }
        }

        private FileObject getRootForNode(BasicNodes node) {
            FileObject sources = this.project.getSourcesFolder();
            FileObject siteRoot = this.project.getSiteRootFolder();
            switch (node) {
                case Sources: {
                    if (sources == null) {
                        return null;
                    }
                    if (sources.equals(siteRoot)) {
                        return null;
                    }
                    return sources;
                }
                case SiteRoot: {
                    if (siteRoot == null) {
                        return null;
                    }
                    if (siteRoot.equals(sources)) {
                        return null;
                    }
                    return siteRoot;
                }
                case SourcesAndSiteRoot: {
                    if (sources == null || siteRoot == null) {
                        return null;
                    }
                    if (sources.equals(siteRoot)) {
                        return sources;
                    }
                    return null;
                }
                case Tests: {
                    return this.project.getTestsFolder(false);
                }
                case TestsSelenium: {
                    return this.project.getTestsSeleniumFolder(false);
                }
            }
            assert (false) : "Unknown node: " + (Object)((Object)node);
            return null;
        }

        private Node createNodeForFolder(Key key) {
            BasicNodes node = key.getNode();
            FileObject root = key.getRoot();
            assert (root != null);
            assert (root.isValid()) : root;
            DataFolder df = DataFolder.findFolder((FileObject)root);
            return new FolderFilterNode(this.project, node, df.getNodeDelegate().cloneNode(), this.getIgnoredFiles(node));
        }

        public List<Key> keys() {
            BasicNodes[] allNodes = BasicNodes.values();
            ArrayList<Key> keys = new ArrayList<Key>(allNodes.length);
            for (BasicNodes node : allNodes) {
                FileObject root = this.getRootForNode(node);
                if (root == null || !root.isValid()) continue;
                keys.add(new Key(node, root));
            }
            return keys;
        }
    }

    public static final class BaseHTML5ProjectNodeFactory
    implements NodeFactory {
        public NodeList createNodes(Project p) {
            return new ClientProjectNodeList((ClientSideProject)p);
        }
    }

    private static enum BasicNodes {
        Sources,
        SiteRoot,
        SourcesAndSiteRoot,
        Tests,
        TestsSelenium;

    }
}

