/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.browser;

import java.util.EnumSet;
import javax.swing.JPanel;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.browser.BrowserActionProvider;
import org.netbeans.modules.web.clientproject.browser.RefreshOnSaveListenerImpl;
import org.netbeans.modules.web.clientproject.env.CommonProjectHelper;
import org.netbeans.modules.web.clientproject.spi.platform.ClientProjectEnhancedBrowserImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.netbeans.modules.web.clientproject.spi.platform.RefreshOnSaveListener;
import org.netbeans.modules.web.clientproject.ui.browser.BrowserConfigurationPanel;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.EditableProperties;

public class ClientProjectEnhancedBrowserImpl
implements ClientProjectEnhancedBrowserImplementation {
    private final ClientSideProject project;
    private final WebBrowser browser;
    private BrowserSupport browserSupport;
    private ProjectConfigurationCustomizerImpl cust = null;

    public ClientProjectEnhancedBrowserImpl(ClientSideProject project, WebBrowser browser) {
        this.project = project;
        this.browser = browser;
    }

    public void save() {
        if (this.cust != null && this.cust.hasDataToSave()) {
            EditableProperties p = this.project.getProjectHelper().getProperties(CommonProjectHelper.PROJECT_PROPERTIES_PATH);
            p.put("browser.autorefresh." + this.browser.getId(), Boolean.toString(this.cust.panel.isAutoRefresh()));
            p.put("browser.highlightselection." + this.browser.getId(), Boolean.toString(this.cust.panel.isHighlightSelection()));
            this.project.getProjectHelper().putProperties(CommonProjectHelper.PROJECT_PROPERTIES_PATH, p);
        }
    }

    public boolean isAutoRefresh() {
        String val = this.project.getEvaluator().getProperty("browser.autorefresh." + this.browser.getId());
        if (val != null) {
            return Boolean.parseBoolean(val);
        }
        return true;
    }

    public boolean isHighlightSelectionEnabled() {
        String val = this.project.getEvaluator().getProperty("browser.highlightselection." + this.browser.getId());
        if (val != null) {
            return Boolean.parseBoolean(val);
        }
        return true;
    }

    public RefreshOnSaveListener getRefreshOnSaveListener() {
        return new RefreshOnSaveListenerImpl(this.project, this.getBrowserSupport(), this);
    }

    public ActionProvider getActionProvider() {
        return new BrowserActionProvider(this.project, this.getBrowserSupport(), this);
    }

    public ProjectConfigurationCustomizer getProjectConfigurationCustomizer() {
        if (this.cust == null) {
            this.cust = new ProjectConfigurationCustomizerImpl();
        }
        return this.cust;
    }

    public BrowserSupport getBrowserSupport() {
        if (this.browserSupport == null) {
            this.browserSupport = this.browser.isEmbedded() ? BrowserSupport.getDefaultEmbedded() : BrowserSupport.create((WebBrowser)this.browser);
        }
        return this.browserSupport;
    }

    public void deactivate() {
        if (this.browserSupport != null) {
            this.getBrowserSupport().close(false);
        }
    }

    public void close() {
        if (this.browserSupport != null) {
            this.getBrowserSupport().close(true);
        }
    }

    private class ProjectConfigurationCustomizerImpl
    implements ProjectConfigurationCustomizer {
        private BrowserConfigurationPanel panel;

        private ProjectConfigurationCustomizerImpl() {
        }

        public JPanel createPanel() {
            this.panel = new BrowserConfigurationPanel(ClientProjectEnhancedBrowserImpl.this.project, ClientProjectEnhancedBrowserImpl.this, ClientProjectEnhancedBrowserImpl.this.browser);
            return this.panel;
        }

        public EnumSet<ProjectConfigurationCustomizer.HiddenProperties> getHiddenProperties() {
            return EnumSet.noneOf(ProjectConfigurationCustomizer.HiddenProperties.class);
        }

        boolean hasDataToSave() {
            return ClientProjectEnhancedBrowserImpl.this.browser.hasNetBeansIntegration() || ClientProjectEnhancedBrowserImpl.this.browser.getBrowserFamily() == BrowserFamilyId.CHROME;
        }
    }
}

