/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer.type;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.web.beans.analysis.CdiAnalysisResult;
import org.netbeans.modules.web.beans.analysis.analyzer.AbstractTypedAnalyzer;
import org.netbeans.modules.web.beans.analysis.analyzer.ClassElementAnalyzer;
import org.openide.util.NbBundle;

public class TypedClassAnalizer
extends AbstractTypedAnalyzer
implements ClassElementAnalyzer.ClassAnalyzer {
    @Override
    public void analyze(TypeElement element, TypeElement parent, AtomicBoolean cancel, CdiAnalysisResult result) {
        this.analyze((Element)element, element.asType(), cancel, result);
    }

    @Override
    protected void addError(Element element, CdiAnalysisResult result) {
        result.addError(element, NbBundle.getMessage(TypedClassAnalizer.class, (String)"ERR_BadRestritedType"));
    }

    @Override
    protected void checkSpecializes(Element element, TypeMirror elementType, List<TypeMirror> restrictedTypes, AtomicBoolean cancel, CdiAnalysisResult result) {
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superclass = typeElement.getSuperclass();
        Element superElement = result.getInfo().getTypes().asElement(superclass);
        if (!(superElement instanceof TypeElement)) {
            return;
        }
        List<TypeMirror> restrictedSuper = this.getRestrictedTypes(superElement, result.getInfo(), cancel);
        if (cancel.get()) {
            return;
        }
        Set<TypeElement> specializedBeanTypes = restrictedSuper == null ? this.getUnrestrictedBeanTypes((TypeElement)superElement, result.getInfo()) : this.getElements(restrictedSuper, result.getInfo());
        Set<TypeElement> restrictedElements = this.getElements(restrictedTypes, result.getInfo());
        restrictedElements.add(result.getInfo().getElements().getTypeElement(Object.class.getCanonicalName()));
        if (!restrictedElements.containsAll(specializedBeanTypes)) {
            result.addError(element, NbBundle.getMessage(TypedClassAnalizer.class, (String)"ERR_BadSpecializesBeanType"));
        }
    }
}

